/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class AutoFocusManager {
    private final Camera mCamera;
    @Nullable
    private final FocusMoveCallback mCallback;
    @Nullable
    private FocusManager mFocusManager;
    private Handler mHandler;

    public AutoFocusManager(Camera camera, @Nullable FocusMoveCallback focusMoveCallback) {
        AutoFocusManager autoFocusManager = this;
        this.mCamera = camera;
        autoFocusManager.mCallback = focusMoveCallback;
        autoFocusManager.mHandler = new Handler(Looper.myLooper());
    }

    private boolean isCameraFocusContinuous() {
        String string2 = ((AutoFocusManager)((Object)string2)).mCamera.getParameters().getFocusMode();
        return "continuous-picture".equals(string2) || "continuous-video".equals(string2) || "edof".equals(string2);
    }

    private boolean isCameraFocusManual() {
        String string2 = ((AutoFocusManager)((Object)string2)).mCamera.getParameters().getFocusMode();
        return "auto".equals(string2) || "macro".equals(string2);
    }

    public void start() {
        AutoFocusManager autoFocusManager;
        FocusManager focusManager = autoFocusManager.mFocusManager;
        if (focusManager != null) {
            focusManager.stop();
            autoFocusManager.mFocusManager = null;
        }
        if (autoFocusManager.isCameraFocusContinuous()) {
            AutoFocusManagerImpl autoFocusManagerImpl;
            focusManager = autoFocusManagerImpl;
            AutoFocusManager autoFocusManager2 = autoFocusManager;
            AutoFocusManager autoFocusManager3 = autoFocusManager;
            autoFocusManager = autoFocusManager3.mCamera;
            FocusMoveCallback focusMoveCallback = autoFocusManager3.mCallback;
            Handler handler = autoFocusManager3.mHandler;
            ((AutoFocusManagerImpl)focusManager)((Camera)autoFocusManager, focusMoveCallback, handler);
            autoFocusManager2.mFocusManager = focusManager;
            autoFocusManagerImpl.start();
        } else if (autoFocusManager.isCameraFocusManual()) {
            ManualFocusManagerImpl manualFocusManagerImpl;
            focusManager = manualFocusManagerImpl;
            AutoFocusManager autoFocusManager4 = autoFocusManager;
            AutoFocusManager autoFocusManager5 = autoFocusManager;
            autoFocusManager = autoFocusManager5.mCamera;
            FocusMoveCallback focusMoveCallback = autoFocusManager5.mCallback;
            Handler handler = autoFocusManager5.mHandler;
            ((ManualFocusManagerImpl)focusManager)((Camera)autoFocusManager, focusMoveCallback, handler);
            autoFocusManager4.mFocusManager = focusManager;
            manualFocusManagerImpl.start();
        }
    }

    public void stop() {
        FocusManager focusManager = this.mFocusManager;
        if (focusManager != null) {
            focusManager.stop();
            this.mFocusManager = null;
        }
    }

    public void requestFocus() {
        FocusManager focusManager = ((AutoFocusManager)((Object)focusManager)).mFocusManager;
        if (focusManager != null) {
            focusManager.requestFocus();
        }
    }

    public static interface FocusMoveCallback {
        public void onAutoFocusMoving(boolean var1, Camera var2);

        public void onAutoFocusComplete(boolean var1, Camera var2);
    }

    private static interface FocusManager {
        public void start();

        public void stop();

        public void requestFocus();
    }

    private static class AutoFocusManagerImpl
    implements FocusManager {
        private final Camera mCamera;
        @Nullable
        private final FocusMoveCallback mCallback;
        private final Handler mHandler;
        private boolean mCameraMoving;
        private final Runnable mResetFocusRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    2 v0 = this;
                    v0.AutoFocusManagerImpl.this.resumeAutoFocus();
                    v0.AutoFocusManagerImpl.this.restartCounter(1000);
                }
                catch (Exception exception) {}
            }
        };

        @TargetApi(value=16)
        public AutoFocusManagerImpl(Camera object, @Nullable FocusMoveCallback focusMoveCallback, Handler handler) {
            this.mCamera = object;
            this.mCallback = focusMoveCallback;
            this.mHandler = handler;
            if (Build.VERSION.SDK_INT >= 16 && focusMoveCallback != null) {
                Camera.AutoFocusMoveCallback autoFocusMoveCallback;
                Camera camera = object;
                object = autoFocusMoveCallback;
                autoFocusMoveCallback = new Camera.AutoFocusMoveCallback(){

                    public void onAutoFocusMoving(boolean bl, Camera camera) {
                        1 v0 = this;
                        v0.AutoFocusManagerImpl.this.mCallback.onAutoFocusMoving(bl, camera);
                        AutoFocusManagerImpl.access$702(v0.AutoFocusManagerImpl.this, bl);
                    }
                };
                camera.setAutoFocusMoveCallback((Camera.AutoFocusMoveCallback)object);
            }
        }

        private void resumeAutoFocus() {
            this.cancelAutoFocusSafe();
        }

        private void restartCounter(int n) {
            ((AutoFocusManagerImpl)((Object)runnable)).mHandler.removeCallbacks(((AutoFocusManagerImpl)((Object)runnable)).mResetFocusRunnable);
            if (n == 0) {
                ((AutoFocusManagerImpl)((Object)runnable)).mHandler.post(((AutoFocusManagerImpl)((Object)runnable)).mResetFocusRunnable);
            } else {
                Runnable runnable = ((AutoFocusManagerImpl)((Object)runnable)).mResetFocusRunnable;
                long l = n;
                ((AutoFocusManagerImpl)((Object)runnable)).mHandler.postDelayed(runnable, l);
            }
        }

        private void cancelAutoFocusSafe() {
            try {
                this.mCamera.cancelAutoFocus();
            }
            catch (RuntimeException runtimeException) {}
        }

        static /* synthetic */ boolean access$702(AutoFocusManagerImpl autoFocusManagerImpl, boolean bl) {
            autoFocusManagerImpl.mCameraMoving = bl;
            return bl;
        }

        @Override
        public void start() {
            AutoFocusManagerImpl autoFocusManagerImpl = this;
            autoFocusManagerImpl.resumeAutoFocus();
            autoFocusManagerImpl.restartCounter(1000);
        }

        @Override
        public void stop() {
            this.mHandler.removeCallbacks(this.mResetFocusRunnable);
        }

        @Override
        public void requestFocus() {
            if (!this.mCameraMoving) {
                AutoFocusManagerImpl autoFocusManagerImpl = this;
                autoFocusManagerImpl.cancelAutoFocusSafe();
                autoFocusManagerImpl.restartCounter(1000);
            }
        }
    }

    private static class ManualFocusManagerImpl
    implements FocusManager {
        private static boolean sFocusCompleteWorking;
        private final Camera mCamera;
        @Nullable
        private final FocusMoveCallback mCallback;
        private final Handler mHandler;
        private boolean mIsFocusMoving;
        private final Runnable mRequestFocusRunnable = new Runnable(){

            @Override
            public void run() {
                block5: {
                    2 v0 = this;
                    2 v1 = v0;
                    v0.ManualFocusManagerImpl.this.mCamera.autoFocus(ManualFocusManagerImpl.this.mAutoFocusCallback);
                    ManualFocusManagerImpl.access$302(v0.ManualFocusManagerImpl.this, true);
                    if (v1.ManualFocusManagerImpl.this.mCallback == null) break block5;
                    FocusMoveCallback focusMoveCallback = ManualFocusManagerImpl.this.mCallback;
                    try {
                        focusMoveCallback.onAutoFocusMoving(true, ManualFocusManagerImpl.this.mCamera);
                    }
                    catch (Exception exception) {
                        2 v4 = this;
                        ManualFocusManagerImpl.access$302(v4.ManualFocusManagerImpl.this, false);
                        if (v4.ManualFocusManagerImpl.this.mCallback == null) break block5;
                        ManualFocusManagerImpl.this.mCallback.onAutoFocusMoving(false, ManualFocusManagerImpl.this.mCamera);
                    }
                }
            }
        };
        private final Camera.AutoFocusCallback mAutoFocusCallback = new Camera.AutoFocusCallback(){

            /*
             * WARNING - void declaration
             */
            public void onAutoFocus(boolean bl, Camera camera) {
                void var1_4;
                ManualFocusManagerImpl manualFocusManagerImpl;
                if (manualFocusManagerImpl.ManualFocusManagerImpl.this.mCallback != null) {
                    void var2_5;
                    manualFocusManagerImpl.ManualFocusManagerImpl.this.mCallback.onAutoFocusComplete(bl, (Camera)var2_5);
                }
                ManualFocusManagerImpl.access$302(manualFocusManagerImpl.ManualFocusManagerImpl.this, false);
                if (!sFocusCompleteWorking) {
                    sFocusCompleteWorking = true;
                }
                manualFocusManagerImpl = manualFocusManagerImpl.ManualFocusManagerImpl.this;
                if (bl) {
                    int n = 3000;
                } else {
                    int n = 500;
                }
                manualFocusManagerImpl.restartCounter((int)var1_4);
            }
        };

        @TargetApi(value=16)
        public ManualFocusManagerImpl(Camera object, @Nullable FocusMoveCallback focusMoveCallback, Handler handler) {
            this.mCamera = object;
            this.mCallback = focusMoveCallback;
            this.mHandler = handler;
            if (Build.VERSION.SDK_INT >= 16 && focusMoveCallback != null) {
                Camera.AutoFocusMoveCallback autoFocusMoveCallback;
                Camera camera = object;
                object = autoFocusMoveCallback;
                autoFocusMoveCallback = new Camera.AutoFocusMoveCallback(){

                    public void onAutoFocusMoving(boolean bl, Camera camera) {
                        ManualFocusManagerImpl.this.mCallback.onAutoFocusMoving(bl, camera);
                    }
                };
                camera.setAutoFocusMoveCallback((Camera.AutoFocusMoveCallback)object);
            }
        }

        private void restartCounter(int n) {
            ((ManualFocusManagerImpl)((Object)runnable)).mHandler.removeCallbacks(((ManualFocusManagerImpl)((Object)runnable)).mRequestFocusRunnable);
            if (n == 0) {
                ((ManualFocusManagerImpl)((Object)runnable)).mHandler.post(((ManualFocusManagerImpl)((Object)runnable)).mRequestFocusRunnable);
            } else {
                Runnable runnable = ((ManualFocusManagerImpl)((Object)runnable)).mRequestFocusRunnable;
                long l = n;
                ((ManualFocusManagerImpl)((Object)runnable)).mHandler.postDelayed(runnable, l);
            }
        }

        private void cancelAutoFocusSafe() {
            try {
                this.mCamera.cancelAutoFocus();
            }
            catch (RuntimeException runtimeException) {}
        }

        static /* synthetic */ boolean access$302(ManualFocusManagerImpl manualFocusManagerImpl, boolean bl) {
            manualFocusManagerImpl.mIsFocusMoving = bl;
            return bl;
        }

        @Override
        public void start() {
            ManualFocusManagerImpl manualFocusManagerImpl = this;
            manualFocusManagerImpl.cancelAutoFocusSafe();
            manualFocusManagerImpl.restartCounter(500);
        }

        @Override
        public void stop() {
            ManualFocusManagerImpl manualFocusManagerImpl = this;
            manualFocusManagerImpl.mHandler.removeCallbacks(this.mRequestFocusRunnable);
            manualFocusManagerImpl.cancelAutoFocusSafe();
        }

        @Override
        public void requestFocus() {
            if (!this.mIsFocusMoving || !sFocusCompleteWorking) {
                ManualFocusManagerImpl manualFocusManagerImpl = this;
                manualFocusManagerImpl.cancelAutoFocusSafe();
                manualFocusManagerImpl.restartCounter(0);
            }
        }
    }
}

