/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.SoundPool;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.URLSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import cards.pay.paycardsrecognizer.sdk.Card;
import cards.pay.paycardsrecognizer.sdk.R;
import cards.pay.paycardsrecognizer.sdk.camera.ScanManager;
import cards.pay.paycardsrecognizer.sdk.camera.widget.CameraPreviewLayout;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionResult;
import cards.pay.paycardsrecognizer.sdk.ui.ScanCardRequest;
import cards.pay.paycardsrecognizer.sdk.ui.views.ProgressBarIndeterminate;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ScanCardFragment
extends Fragment {
    private CameraPreviewLayout mCameraPreviewLayout;
    private ProgressBarIndeterminate mProgressBar;
    private ViewGroup mMainContent;
    @Nullable
    private View mFlashButton;
    @Nullable
    private ScanManager mScanManager;
    private SoundPool mSoundPool;
    private int mCapturedSoundId = -1;
    private InteractionListener mListener;
    private ScanCardRequest mRequest;

    private void innitSoundPool() {
        if (this.mRequest.isSoundEnabled()) {
            SoundPool soundPool;
            SoundPool soundPool2;
            SoundPool soundPool3 = soundPool2 = soundPool;
            soundPool3(1, 1, 0);
            this.mSoundPool = soundPool3;
            this.mCapturedSoundId = soundPool.load((Context)this.getActivity(), R.raw.wocr_capture_card, 0);
        }
    }

    private void initView(View object) {
        URLSpan uRLSpan;
        object = scanCardFragment.mFlashButton;
        if (object != null) {
            View.OnClickListener onClickListener;
            View view = object;
            object = onClickListener;
            onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    if (ScanCardFragment.this.mScanManager != null) {
                        ScanCardFragment.this.mScanManager.toggleFlash();
                    }
                }
            };
            view.setOnClickListener((View.OnClickListener)object);
        }
        SpannableString spannableString = new SpannableString(scanCardFragment.getText(R.string.wocr_powered_by_pay_cards));
        ScanCardFragment scanCardFragment = uRLSpan;
        uRLSpan = new URLSpan("https://pay.cards");
        int n = spannableString.length();
        spannableString.setSpan((Object)scanCardFragment, 0, n, 17);
    }

    private void showMainContent() {
        ScanCardFragment scanCardFragment = this;
        scanCardFragment.mMainContent.setVisibility(0);
        scanCardFragment.mCameraPreviewLayout.setVisibility(0);
    }

    private void hideMainContent() {
        ScanCardFragment scanCardFragment = this;
        scanCardFragment.mMainContent.setVisibility(4);
        scanCardFragment.mCameraPreviewLayout.setVisibility(4);
    }

    private void finishWithError(Exception exception) {
        InteractionListener interactionListener = ((ScanCardFragment)((Object)interactionListener)).mListener;
        if (interactionListener != null) {
            interactionListener.onScanCardFailed(exception);
        }
    }

    private void finishWithResult(Card card, @Nullable byte[] byArray) {
        InteractionListener interactionListener = ((ScanCardFragment)((Object)interactionListener)).mListener;
        if (interactionListener != null) {
            interactionListener.onScanCardFinished(card, byArray);
        }
    }

    private boolean isTablet() {
        return this.getResources().getBoolean(R.bool.wocr_is_tablet);
    }

    private void playCaptureSound() {
        int n = this.mCapturedSoundId;
        if (n >= 0) {
            this.mSoundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    public void onAttach(Context context) {
        ScanCardFragment scanCardFragment = this;
        super.onAttach(context);
        try {
            scanCardFragment.mListener = (InteractionListener)scanCardFragment.getActivity();
        }
        catch (ClassCastException classCastException) {
            try {
                this.mListener = (InteractionListener)this.getParentFragment();
            }
            catch (Exception exception) {}
        }
    }

    public void onCreate(Bundle bundle) {
        ScanCardFragment scanCardFragment = this;
        super.onCreate(bundle);
        scanCardFragment.mRequest = null;
        if (scanCardFragment.getArguments() != null) {
            this.mRequest = (ScanCardRequest)this.getArguments().getParcelable("cards.pay.paycardsrecognizer.sdk.ui.ScanCardActivity.SCAN_CARD_REQUEST");
        }
        if (this.mRequest == null) {
            this.mRequest = ScanCardRequest.getDefault();
        }
    }

    public Animation onCreateAnimation(int n, boolean bl, int n2) {
        Animation animation = new Animation(this){};
        animation.setDuration(0L);
        return animation;
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        layoutInflater = layoutInflater.inflate(R.layout.wocr_fragment_scan_card, viewGroup, false);
        ScanCardFragment scanCardFragment = this;
        this.mProgressBar = (ProgressBarIndeterminate)layoutInflater.findViewById(R.id.wocr_progress_bar);
        this.mCameraPreviewLayout = (CameraPreviewLayout)layoutInflater.findViewById(R.id.wocr_card_recognition_view);
        this.mMainContent = (ViewGroup)layoutInflater.findViewById(R.id.wocr_main_content);
        this.mFlashButton = layoutInflater.findViewById(R.id.wocr_iv_flash_id);
        scanCardFragment.initView((View)layoutInflater);
        scanCardFragment.showMainContent();
        scanCardFragment.mProgressBar.setVisibility(0);
        return layoutInflater;
    }

    public void onActivityCreated(@Nullable Bundle bundle) {
        ScanManager.Callbacks callbacks;
        ScanManager scanManager;
        ScanCardFragment scanCardFragment = this;
        super.onActivityCreated(bundle);
        if (!scanCardFragment.isTablet()) {
            this.getActivity().setRequestedOrientation(1);
        } else {
            this.mCameraPreviewLayout.setBackgroundColor(-16777216);
        }
        int n = 1;
        if (this.mRequest.isScanCardHolderEnabled()) {
            n = 5;
        }
        if (this.mRequest.isScanExpirationDateEnabled()) {
            n |= 2;
        }
        if (this.mRequest.isGrabCardImageEnabled()) {
            n |= 8;
        }
        ScanManager scanManager2 = scanManager;
        ScanCardFragment scanCardFragment2 = this;
        FragmentActivity fragmentActivity = scanCardFragment2.getActivity();
        CameraPreviewLayout cameraPreviewLayout = scanCardFragment2.mCameraPreviewLayout;
        ScanManager.Callbacks callbacks2 = callbacks;
        callbacks = new ScanManager.Callbacks(){
            private byte[] mLastCardImage = null;

            @Nullable
            private byte[] compressCardImage(Bitmap bitmap) {
                ByteArrayOutputStream byteArrayOutputStream;
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                byteArrayOutputStream = new ByteArrayOutputStream();
                return bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)byteArrayOutputStream2) ? byteArrayOutputStream2.toByteArray() : null;
            }

            @Override
            public void onCameraOpened(Camera.Parameters parameters) {
                boolean bl = parameters.getSupportedFlashModes() != null && !parameters.getSupportedFlashModes().isEmpty();
                if (ScanCardFragment.this.getView() == null) {
                    return;
                }
                2 v0 = this;
                v0.ScanCardFragment.this.mProgressBar.hideSlow();
                v0.ScanCardFragment.this.mCameraPreviewLayout.setBackgroundDrawable(null);
                if (v0.ScanCardFragment.this.mFlashButton != null) {
                    View view = ScanCardFragment.this.mFlashButton;
                    int n = bl ? 0 : 8;
                    view.setVisibility(n);
                }
                ScanCardFragment.this.innitSoundPool();
            }

            @Override
            public void onOpenCameraError(Exception exception) {
                2 v0 = this;
                v0.ScanCardFragment.this.mProgressBar.hideSlow();
                v0.ScanCardFragment.this.hideMainContent();
                v0.ScanCardFragment.this.finishWithError(exception);
            }

            @Override
            public void onRecognitionComplete(RecognitionResult object) {
                if (((RecognitionResult)object).isFirst()) {
                    if (card2.ScanCardFragment.this.mScanManager != null) {
                        card2.ScanCardFragment.this.mScanManager.freezeCameraPreview();
                    }
                    card2.ScanCardFragment.this.playCaptureSound();
                }
                if (((RecognitionResult)object).isFinal()) {
                    Card card;
                    String string2 = TextUtils.isEmpty((CharSequence)((RecognitionResult)object).getDate()) ? null : ((RecognitionResult)object).getDate().substring(0, 2) + '/' + ((RecognitionResult)object).getDate().substring(2);
                    2 v0 = card2;
                    Card card2 = card;
                    RecognitionResult recognitionResult = object;
                    object = recognitionResult.getNumber();
                    card = new Card((String)object, recognitionResult.getName(), string2);
                    object = v0.mLastCardImage;
                    v0.mLastCardImage = null;
                    v0.ScanCardFragment.this.finishWithResult(card2, (byte[])object);
                }
            }

            @Override
            public void onCardImageReceived(Bitmap bitmap) {
                this.mLastCardImage = this.compressCardImage(bitmap);
            }

            @Override
            public void onFpsReport(String string2) {
            }

            @Override
            public void onAutoFocusMoving(boolean bl, String string2) {
            }

            @Override
            public void onAutoFocusComplete(boolean bl, String string2) {
            }
        };
        scanManager = new ScanManager(n, (Context)fragmentActivity, cameraPreviewLayout, callbacks2);
        this.mScanManager = scanManager2;
    }

    public void onStart() {
        super.onStart();
    }

    public void onStop() {
        super.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
    }

    public void onDetach() {
        super.onDetach();
    }

    public void onResume() {
        ScanCardFragment scanCardFragment = scanManager;
        super.onResume();
        ScanManager scanManager = scanCardFragment.mScanManager;
        if (scanManager != null) {
            scanManager.onResume();
        }
    }

    public void onPause() {
        ScanCardFragment scanCardFragment = scanManager;
        super.onPause();
        ScanManager scanManager = scanCardFragment.mScanManager;
        if (scanManager != null) {
            scanManager.onPause();
        }
    }

    public void onDestroy() {
        ScanCardFragment scanCardFragment = this;
        super.onDestroy();
        SoundPool soundPool = scanCardFragment.mSoundPool;
        if (soundPool != null) {
            soundPool.release();
            this.mSoundPool = null;
        }
        this.mCapturedSoundId = -1;
    }

    public static interface InteractionListener {
        public void onScanCardFailed(Exception var1);

        public void onScanCardFinished(Card var1, byte[] var2);
    }
}

