/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.RestrictTo;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import cards.pay.paycardsrecognizer.sdk.R;
import cards.pay.paycardsrecognizer.sdk.camera.widget.CardDetectionStateView;
import cards.pay.paycardsrecognizer.sdk.camera.widget.CardRectCoordsMapper;
import cards.pay.paycardsrecognizer.sdk.camera.widget.OnWindowFocusChangedListener;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class CameraPreviewLayout
extends FrameLayout {
    private SurfaceView mSurfaceView;
    private CardDetectionStateView mDetectionStateOverlay;
    private OnWindowFocusChangedListener mWindowFocusChangedListener;
    private final CardRectCoordsMapper mCardFrame;
    private final Rect mTmp;

    public CameraPreviewLayout(Context context) {
        this(context, null);
    }

    public CameraPreviewLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CameraPreviewLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        new Rect();
        this.mTmp = new Rect();
        this.mCardFrame = new CardRectCoordsMapper();
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void getChildRect(int n, Rect rect, Rect rect2, LayoutParams layoutParams, int n2, int n3) {
        int n4 = GravityCompat.getAbsoluteGravity((int)CameraPreviewLayout.resolveGravity(layoutParams.cardGravity), (int)n);
        n = n4 & 7;
        n4 &= 0x70;
        n = n != 1 ? (n != 5 ? rect.left + layoutParams.leftMargin : rect.right - n2 - layoutParams.rightMargin) : rect.left + rect.width() / 2 - n2 / 2 + layoutParams.leftMargin - layoutParams.rightMargin;
        n4 = n4 != 16 ? (n4 != 80 ? rect.top - n3 - layoutParams.bottomMargin : rect.bottom + layoutParams.topMargin) : rect.top + rect.height() / 2 - n3 / 2 + layoutParams.topMargin - layoutParams.bottomMargin;
        int n5 = n + n2;
        int n6 = n4 + n3;
        rect2.set(n, n4, n5, n6);
    }

    private static int resolveGravity(int n) {
        if ((n & 7) == 0) {
            n |= 0x800003;
        }
        if ((n & 0x70) == 0) {
            n |= 0x30;
        }
        return n;
    }

    private void constrainChildRect(LayoutParams layoutParams, Rect rect, int n, int n2) {
        CameraPreviewLayout cameraPreviewLayout = this;
        int n3 = cameraPreviewLayout.getWidth();
        int n4 = cameraPreviewLayout.getHeight();
        n3 = Math.max(cameraPreviewLayout.getPaddingLeft() + layoutParams.leftMargin, Math.min(rect.left, n3 - this.getPaddingRight() - n - layoutParams.rightMargin));
        int n5 = Math.max(this.getPaddingTop() + layoutParams.topMargin, Math.min(rect.top, n4 - this.getPaddingBottom() - n2 - layoutParams.bottomMargin));
        int n6 = n3 + n;
        int n7 = n5 + n2;
        rect.set(n3, n5, n6, n7);
    }

    public SurfaceView getSurfaceView() {
        return this.mSurfaceView;
    }

    public CardDetectionStateView getDetectionStateOverlay() {
        return this.mDetectionStateOverlay;
    }

    public void setOnWindowFocusChangedListener(OnWindowFocusChangedListener onWindowFocusChangedListener) {
        this.mWindowFocusChangedListener = onWindowFocusChangedListener;
    }

    public void setCameraParameters(int n, int n2, int n3, Rect rect) {
        CameraPreviewLayout cameraPreviewLayout = this;
        cameraPreviewLayout.mDetectionStateOverlay.setCameraParameters(n, n2, n3, rect);
        if (cameraPreviewLayout.mCardFrame.setCameraParameters(n, n2, n3, rect) && !ViewCompat.isInLayout((View)this)) {
            this.requestLayout();
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        CameraPreviewLayout cameraPreviewLayout = this;
        super.onSizeChanged(n, n2, n3, n4);
        if (cameraPreviewLayout.mCardFrame.setViewSize(n, n2) && !ViewCompat.isInLayout((View)this)) {
            this.requestLayout();
        }
    }

    protected void onFinishInflate() {
        CameraPreviewLayout cameraPreviewLayout = this;
        super.onFinishInflate();
        cameraPreviewLayout.mSurfaceView = (SurfaceView)cameraPreviewLayout.getChildAt(0);
        cameraPreviewLayout.mDetectionStateOverlay = (CardDetectionStateView)cameraPreviewLayout.getChildAt(1);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void onWindowFocusChanged(boolean bl) {
        CameraPreviewLayout cameraPreviewLayout = this;
        super.onWindowFocusChanged(bl);
        OnWindowFocusChangedListener onWindowFocusChangedListener = cameraPreviewLayout.mWindowFocusChangedListener;
        if (onWindowFocusChangedListener != null) {
            onWindowFocusChangedListener.onWindowFocusChanged((View)this, bl);
        }
    }

    protected void onLayout(boolean n, int n2, int n3, int n4, int n5) {
        CameraPreviewLayout cameraPreviewLayout = this;
        super.onLayout(n != 0, n2, n3, n4, n5);
        n = cameraPreviewLayout.getChildCount();
        Rect rect = cameraPreviewLayout.mCardFrame.getCardRect();
        for (n3 = 0; n3 < n; ++n3) {
            View view = this.getChildAt(n3);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (view.getVisibility() == 8 || layoutParams.cardGravity == -1) continue;
            CameraPreviewLayout cameraPreviewLayout2 = this;
            View view2 = view;
            int n6 = ViewCompat.getLayoutDirection((View)this);
            int n7 = view2.getMeasuredWidth();
            int n8 = view2.getMeasuredHeight();
            Rect rect2 = cameraPreviewLayout2.mTmp;
            cameraPreviewLayout2.getChildRect(n6, rect, rect2, layoutParams, n7, n8);
            cameraPreviewLayout2.constrainChildRect(layoutParams, cameraPreviewLayout2.mTmp, n7, n8);
            Rect rect3 = cameraPreviewLayout2.mTmp;
            n6 = rect3.left;
            int n9 = rect3.top;
            n7 = rect3.right;
            n8 = rect3.bottom;
            view.layout(n6, n9, n7, n8);
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public int cardGravity = -1;

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, R.styleable.wocr_CameraPreviewLayout_Layout);
            if (context.hasValue(R.styleable.wocr_CameraPreviewLayout_Layout_wocr_layout_cardAlignGravity)) {
                this.cardGravity = context.getInt(R.styleable.wocr_CameraPreviewLayout_Layout_wocr_layout_cardAlignGravity, 17);
            }
            context.recycle();
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }
}

