/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera.gles;

import android.support.annotation.RestrictTo;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import cards.pay.paycardsrecognizer.sdk.camera.gles.EglCore;
import javax.microedition.khronos.egl.EGLSurface;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class WindowSurface {
    protected EglCore mEglCore;
    private Surface mSurface;
    private boolean mReleaseSurface;
    private EGLSurface mEGLSurface = null;
    private int mWidth = -1;
    private int mHeight = -1;

    public WindowSurface(EglCore eglCore, SurfaceHolder surfaceHolder, boolean bl) {
        this.mEglCore = eglCore;
        this.createWindowSurface(surfaceHolder);
        this.mSurface = surfaceHolder.getSurface();
        this.mReleaseSurface = bl;
    }

    public void release() {
        WindowSurface windowSurface = this;
        windowSurface.releaseEglSurface();
        Surface surface = windowSurface.mSurface;
        if (surface != null) {
            if (this.mReleaseSurface) {
                surface.release();
            }
            this.mSurface = null;
        }
    }

    public void createWindowSurface(Object object) {
        if (this.mEGLSurface == null) {
            this.mEGLSurface = this.mEglCore.createWindowSurface(object);
            return;
        }
        throw new IllegalStateException("surface already created");
    }

    public int getWidth() {
        int n = this.mWidth;
        if (n < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12375);
        }
        return n;
    }

    public int getHeight() {
        int n = this.mHeight;
        if (n < 0) {
            return this.mEglCore.querySurface(this.mEGLSurface, 12374);
        }
        return n;
    }

    public void releaseEglSurface() {
        this.mEglCore.releaseSurface(this.mEGLSurface);
        this.mEGLSurface = null;
        this.mHeight = -1;
        this.mWidth = -1;
    }

    public void makeCurrent() {
        this.mEglCore.makeCurrent(this.mEGLSurface);
    }

    public boolean swapBuffers() {
        boolean bl = this.mEglCore.swapBuffers(this.mEGLSurface);
        if (!bl) {
            Log.d((String)"gles", (String)"WARNING: swapBuffers() failed");
        }
        return bl;
    }
}

