/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera.gles;

import android.opengl.Matrix;
import android.support.annotation.RestrictTo;
import cards.pay.paycardsrecognizer.sdk.camera.gles.Drawable2d;
import cards.pay.paycardsrecognizer.sdk.camera.gles.GlUtil;
import cards.pay.paycardsrecognizer.sdk.camera.gles.Texture2dProgram;
import java.nio.FloatBuffer;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class Sprite2d {
    private Drawable2d mDrawable;
    private float[] mColor;
    private int mTextureId;
    private float mAngle;
    private float mScaleX;
    private float mScaleY;
    private float mPosX;
    private float mPosY;
    private float[] mModelViewMatrix;
    private boolean mMatrixReady;
    private float[] mScratchMatrix;

    public Sprite2d(Drawable2d drawable2d) {
        Sprite2d sprite2d = this;
        this.mScratchMatrix = new float[16];
        sprite2d.mDrawable = drawable2d;
        float[] fArray = new float[4];
        this.mColor = fArray;
        fArray[3] = 1.0f;
        sprite2d.mTextureId = -1;
        sprite2d.mModelViewMatrix = new float[16];
        sprite2d.mMatrixReady = false;
    }

    private void recomputeMatrix() {
        Sprite2d sprite2d = this;
        float[] fArray = sprite2d.mModelViewMatrix;
        Sprite2d sprite2d2 = this;
        Matrix.setIdentityM((float[])fArray, (int)0);
        float f = sprite2d2.mPosX;
        float f2 = sprite2d2.mPosY;
        Matrix.translateM((float[])sprite2d.mModelViewMatrix, (int)0, (float)f, (float)f2, (float)0.0f);
        f = sprite2d.mAngle;
        if (f != 0.0f) {
            Matrix.rotateM((float[])fArray, (int)0, (float)f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        Sprite2d sprite2d3 = this;
        float f3 = sprite2d3.mScaleX;
        float f4 = sprite2d3.mScaleY;
        Matrix.scaleM((float[])fArray, (int)0, (float)f3, (float)f4, (float)1.0f);
        this.mMatrixReady = true;
    }

    public void setScale(float f, float f2) {
        Sprite2d sprite2d = this;
        sprite2d.mScaleX = f;
        sprite2d.mScaleY = f2;
        sprite2d.mMatrixReady = false;
    }

    public void setRotation(float f) {
        while (f >= 360.0f) {
            f -= 360.0f;
        }
        while (f <= -360.0f) {
            f += 360.0f;
        }
        Sprite2d sprite2d = this;
        sprite2d.mAngle = f;
        sprite2d.mMatrixReady = false;
    }

    public void setPosition(float f, float f2) {
        Sprite2d sprite2d = this;
        sprite2d.mPosX = f;
        sprite2d.mPosY = f2;
        sprite2d.mMatrixReady = false;
    }

    public float[] getModelViewMatrix() {
        if (!this.mMatrixReady) {
            this.recomputeMatrix();
        }
        return this.mModelViewMatrix;
    }

    public void setTexture(int n) {
        this.mTextureId = n;
    }

    public void draw(Texture2dProgram object, float[] object2) {
        Texture2dProgram texture2dProgram = object;
        Sprite2d sprite2d = this;
        object = this.getModelViewMatrix();
        Matrix.multiplyMM((float[])sprite2d.mScratchMatrix, (int)0, (float[])object2, (int)0, (float[])object, (int)0);
        object = sprite2d.mScratchMatrix;
        object2 = sprite2d.mDrawable.getVertexArray();
        int n = sprite2d.mDrawable.getVertexCount();
        int n2 = sprite2d.mDrawable.getCoordsPerVertex();
        int n3 = sprite2d.mDrawable.getVertexStride();
        float[] fArray = GlUtil.IDENTITY_MATRIX;
        FloatBuffer floatBuffer = sprite2d.mDrawable.getTexCoordArray();
        int n4 = sprite2d.mTextureId;
        int n5 = this.mDrawable.getTexCoordStride();
        texture2dProgram.draw((float[])object, (FloatBuffer)object2, 0, n, n2, n3, fArray, floatBuffer, n4, n5);
    }

    public String toString() {
        return "[Sprite2d pos=" + this.mPosX + "," + this.mPosY + " scale=" + this.mScaleX + "," + this.mScaleY + " angle=" + this.mAngle + " color={" + this.mColor[0] + "," + this.mColor[1] + "," + this.mColor[2] + "} drawable=" + this.mDrawable + "]";
    }
}

