/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.ModulusTenCheckDigit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ModulusTenSedolCheckDigitTest
extends AbstractCheckDigitTest {
    private static final String[] INVALID_CHECK_DIGITS = new String[]{"026349E", "087061C", "B06LQ9H", "343757F", "B07LF5F"};

    @BeforeEach
    protected void setUp() {
        this.routine = new ModulusTenCheckDigit(new int[]{1, 3, 1, 7, 3, 9, 1});
        this.valid = new String[]{"0263494", "0870612", "B06LQ97", "3437575", "B07LF55"};
        this.invalid = new String[]{"123#567"};
        this.zeroSum = "0000000";
    }

    @Test
    public void testValidator346() {
        for (String invalidCheckDigit : INVALID_CHECK_DIGITS) {
            Assertions.assertFalse((boolean)this.routine.isValid(invalidCheckDigit), () -> "Should fail: " + invalidCheckDigit);
        }
    }
}

