/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.CurrencyValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CurrencyValidatorTest {
    private static final char CURRENCY_SYMBOL = '\u00a4';
    private String usDollar;
    private String ukPound;

    @BeforeEach
    protected void setUp() {
        this.usDollar = new DecimalFormatSymbols(Locale.US).getCurrencySymbol();
        this.ukPound = new DecimalFormatSymbols(Locale.UK).getCurrencySymbol();
    }

    @Test
    public void testFormatType() {
        Assertions.assertEquals((int)1, (int)CurrencyValidator.getInstance().getFormatType(), (String)"Format Type A");
        Assertions.assertEquals((int)1, (int)CurrencyValidator.getInstance().getFormatType(), (String)"Format Type B");
    }

    @Test
    public void testIntegerInvalid() {
        CurrencyValidator validator = new CurrencyValidator(true, false);
        Assertions.assertFalse((boolean)validator.isValid(this.ukPound + "1,234.56", Locale.UK), (String)"UK positive");
        Assertions.assertFalse((boolean)validator.isValid("-" + this.ukPound + "1,234.56", Locale.UK), (String)"UK negative");
        Assertions.assertFalse((boolean)validator.isValid(this.usDollar + "1,234.56", Locale.US), (String)"US positive");
        Assertions.assertFalse((boolean)validator.isValid("(" + this.usDollar + "1,234.56)", Locale.US), (String)"US negative");
    }

    @Test
    public void testIntegerValid() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        CurrencyValidator validator = new CurrencyValidator();
        BigDecimal expected = new BigDecimal("1234.00");
        BigDecimal negative = new BigDecimal("-1234.00");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.ukPound + "1,234"), (String)"Default locale");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.ukPound + "1,234", Locale.UK), (String)"UK locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("-" + this.ukPound + "1,234", Locale.UK), (String)"UK negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.usDollar + "1,234", Locale.US), (String)"US locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("(" + this.usDollar + "1,234)", Locale.US), (String)"US negative");
        Locale.setDefault(origDefault);
    }

    @Test
    public void testInvalid() {
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValid(null), (String)"isValid() Null Value");
        Assertions.assertFalse((boolean)validator.isValid(""), (String)"isValid() Empty Value");
        Assertions.assertNull((Object)validator.validate(null), (String)"validate() Null Value");
        Assertions.assertNull((Object)validator.validate(""), (String)"validate() Empty Value");
        Assertions.assertFalse((boolean)validator.isValid(this.usDollar + "1,234.56", Locale.UK), (String)"UK wrong symbol");
        Assertions.assertFalse((boolean)validator.isValid("(" + this.ukPound + "1,234.56)", Locale.UK), (String)"UK wrong negative");
        Assertions.assertFalse((boolean)validator.isValid(this.ukPound + "1,234.56", Locale.US), (String)"US wrong symbol");
        Assertions.assertFalse((boolean)validator.isValid("-" + this.usDollar + "1,234.56", Locale.US), (String)"US wrong negative");
    }

    @Test
    public void testPattern() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        String basicPattern = "\u00a4#,##0.000";
        String pattern = "\u00a4#,##0.000;[\u00a4#,##0.000]";
        BigDecimal expected = new BigDecimal("1234.567");
        BigDecimal negative = new BigDecimal("-1234.567");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.ukPound + "1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"default");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("[" + this.ukPound + "1,234.567]", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"no symbol +ve");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("[1,234.567]", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"no symbol -ve");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.usDollar + "1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"default");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("[" + this.usDollar + "1,234.567]", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"no symbol +ve");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("[1,234.567]", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"no symbol -ve");
        Assertions.assertFalse((boolean)validator.isValid(this.usDollar + "1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]"), (String)"invalid symbol");
        Assertions.assertFalse((boolean)validator.isValid(this.ukPound + "1,234.567", "\u00a4#,##0.000;[\u00a4#,##0.000]", Locale.US), (String)"invalid symbol");
        Locale.setDefault(origDefault);
    }

    @Test
    public void testValid() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        BigDecimal expected = new BigDecimal("1234.56");
        BigDecimal negative = new BigDecimal("-1234.56");
        BigDecimal noDecimal = new BigDecimal("1234.00");
        BigDecimal oneDecimal = new BigDecimal("1234.50");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.ukPound + "1,234.56"), (String)"Default locale");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.ukPound + "1,234.56", Locale.UK), (String)"UK locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("-" + this.ukPound + "1,234.56", Locale.UK), (String)"UK negative");
        Assertions.assertEquals((Object)noDecimal, (Object)validator.validate(this.ukPound + "1,234", Locale.UK), (String)"UK no decimal");
        Assertions.assertEquals((Object)oneDecimal, (Object)validator.validate(this.ukPound + "1,234.5", Locale.UK), (String)"UK 1 decimal");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.ukPound + "1,234.567", Locale.UK), (String)"UK 3 decimal");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("1,234.56", Locale.UK), (String)"UK no symbol");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.usDollar + "1,234.56", Locale.US), (String)"US locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("(" + this.usDollar + "1,234.56)", Locale.US), (String)"US negative");
        Assertions.assertEquals((Object)noDecimal, (Object)validator.validate(this.usDollar + "1,234", Locale.US), (String)"US no decimal");
        Assertions.assertEquals((Object)oneDecimal, (Object)validator.validate(this.usDollar + "1,234.5", Locale.US), (String)"US 1 decimal");
        Assertions.assertEquals((Object)expected, (Object)validator.validate(this.usDollar + "1,234.567", Locale.US), (String)"US 3 decimal");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("1,234.56", Locale.US), (String)"US no symbol");
        Locale.setDefault(origDefault);
    }
}

