/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.ByteValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteValidatorTest
extends AbstractNumberValidatorTest {
    private static final Byte BYTE_MIN_VAL = -128;
    private static final Byte BYTE_MAX_VAL = 127;
    private static final String BYTE_MAX = "127";
    private static final String BYTE_MAX_0 = "127.99999999999999999999999";
    private static final String BYTE_MAX_1 = "128";
    private static final String BYTE_MIN = "-128";
    private static final String BYTE_MIN_0 = "-128.99999999999999999999999";
    private static final String BYTE_MIN_1 = "-129";

    @Override
    @BeforeEach
    protected void setUp() {
        super.setUp();
        this.validator = new ByteValidator(false, 0);
        this.strictValidator = new ByteValidator();
        this.testPattern = "#,###";
        this.max = (byte)127;
        this.maxPlusOne = this.max.longValue() + 1L;
        this.min = (byte)-128;
        this.minMinusOne = this.min.longValue() - 1L;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2", BYTE_MAX_1, BYTE_MIN_1, BYTE_MAX_0, BYTE_MIN_0};
        this.invalid = new String[]{null, "", "X", "X12", BYTE_MAX_1, BYTE_MIN_1};
        this.testNumber = (byte)123;
        this.testZero = (byte)0;
        this.validStrict = new String[]{"0", "123", ",123", BYTE_MAX, BYTE_MIN};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, BYTE_MAX_VAL, BYTE_MIN_VAL};
        this.valid = new String[]{"0", "123", ",123", ",123.5", "123X", BYTE_MAX, BYTE_MIN, BYTE_MAX_0, BYTE_MIN_0};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber, BYTE_MAX_VAL, BYTE_MIN_VAL, BYTE_MAX_VAL, BYTE_MIN_VAL};
        this.testStringUS = ",123";
        this.localeValue = this.testStringDE = ".123";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    @Test
    public void testByteRangeMinMax() {
        ByteValidator validator = (ByteValidator)this.strictValidator;
        Byte number9 = validator.validate("9", "#");
        Byte number10 = validator.validate("10", "#");
        Byte number11 = validator.validate("11", "#");
        Byte number19 = validator.validate("19", "#");
        Byte number20 = validator.validate("20", "#");
        Byte number21 = validator.validate("21", "#");
        int min = 10;
        int max = 20;
        Assertions.assertFalse((boolean)validator.isInRange(number9, (byte)10, (byte)20), (String)"isInRange() < min");
        Assertions.assertTrue((boolean)validator.isInRange(number10, (byte)10, (byte)20), (String)"isInRange() = min");
        Assertions.assertTrue((boolean)validator.isInRange(number11, (byte)10, (byte)20), (String)"isInRange() in range");
        Assertions.assertTrue((boolean)validator.isInRange(number20, (byte)10, (byte)20), (String)"isInRange() = max");
        Assertions.assertFalse((boolean)validator.isInRange(number21, (byte)10, (byte)20), (String)"isInRange() > max");
        Assertions.assertFalse((boolean)validator.minValue(number9, (byte)10), (String)"minValue() < min");
        Assertions.assertTrue((boolean)validator.minValue(number10, (byte)10), (String)"minValue() = min");
        Assertions.assertTrue((boolean)validator.minValue(number11, (byte)10), (String)"minValue() > min");
        Assertions.assertTrue((boolean)validator.maxValue(number19, (byte)20), (String)"maxValue() < max");
        Assertions.assertTrue((boolean)validator.maxValue(number20, (byte)20), (String)"maxValue() = max");
        Assertions.assertFalse((boolean)validator.maxValue(number21, (byte)20), (String)"maxValue() > max");
    }

    @Test
    public void testByteValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00";
        String patternVal = "1,23";
        String germanPatternVal = "1.23";
        String localeVal = ".123";
        String defaultVal = ",123";
        String xxxx = "XXXX";
        Byte expected = 123;
        Assertions.assertEquals((Byte)expected, (Byte)ByteValidator.getInstance().validate(",123"), (String)"validate(A) default");
        Assertions.assertEquals((Byte)expected, (Byte)ByteValidator.getInstance().validate(".123", locale), (String)"validate(A) locale ");
        Assertions.assertEquals((Byte)expected, (Byte)ByteValidator.getInstance().validate("1,23", "0,00"), (String)"validate(A) pattern");
        Assertions.assertEquals((Byte)expected, (Byte)ByteValidator.getInstance().validate("1.23", "0,00", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)ByteValidator.getInstance().isValid(",123"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)ByteValidator.getInstance().isValid(".123", locale), (String)"isValid(A) locale ");
        Assertions.assertTrue((boolean)ByteValidator.getInstance().isValid("1,23", "0,00"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)ByteValidator.getInstance().isValid("1.23", "0,00", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)ByteValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)ByteValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale ");
        Assertions.assertNull((Object)ByteValidator.getInstance().validate("XXXX", "0,00"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)ByteValidator.getInstance().validate("1,23", "0,00", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)ByteValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)ByteValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale ");
        Assertions.assertFalse((boolean)ByteValidator.getInstance().isValid("XXXX", "0,00"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)ByteValidator.getInstance().isValid("1,23", "0,00", Locale.GERMAN), (String)"isValid(B) both");
    }
}

