/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

public class ValidatorResultsTest
extends AbstractCommonTest {
    private static final String FORM_KEY = "nameForm";
    private static final String FIRST_NAME_FIELD = "firstName";
    private static final String MIDDLE_NAME_FIELD = "middleName";
    private static final String LAST_NAME_FIELD = "lastName";
    private String firstName;
    private String middleName;
    private String lastName;

    private void checkNotRun(ValidatorResults results, String field, String action) {
        ValidatorResult result = results.getValidatorResult(field);
        Assertions.assertNotNull((Object)result, () -> field + " result");
        Assertions.assertFalse((boolean)result.containsAction(action), () -> field + "[" + action + "] run");
    }

    private void checkValidatorResult(ValidatorResults results, String field, String action, boolean expected) {
        ValidatorResult result = results.getValidatorResult(field);
        Assertions.assertNotNull((Object)result, () -> field + " result");
        Assertions.assertTrue((boolean)result.containsAction(action), () -> field + "[" + action + "] not run");
        Assertions.assertEquals((Object)expected, (Object)result.isValid(action), () -> field + "[" + action + "] result");
    }

    private NameBean createNameBean() {
        NameBean name = new NameBean();
        name.setFirstName(this.firstName);
        name.setMiddleName(this.middleName);
        name.setLastName(this.lastName);
        return name;
    }

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("ValidatorResultsTest-config.xml");
        this.firstName = "foo";
        this.middleName = "123";
        this.lastName = "456";
    }

    @AfterEach
    protected void tearDown() {
    }

    @Test
    public void testAllValid() throws ValidatorException {
        NameBean bean = this.createNameBean();
        ValidatorResults results = this.validate(bean);
        this.checkValidatorResult(results, FIRST_NAME_FIELD, "required", true);
        this.checkValidatorResult(results, MIDDLE_NAME_FIELD, "required", true);
        this.checkValidatorResult(results, MIDDLE_NAME_FIELD, "int", true);
        this.checkValidatorResult(results, MIDDLE_NAME_FIELD, "positive", true);
        this.checkValidatorResult(results, LAST_NAME_FIELD, "required", true);
        this.checkValidatorResult(results, LAST_NAME_FIELD, "int", true);
    }

    @Test
    public void testErrors() throws ValidatorException {
        this.middleName = "XXX";
        this.lastName = null;
        NameBean bean = this.createNameBean();
        ValidatorResults results = this.validate(bean);
        this.checkValidatorResult(results, FIRST_NAME_FIELD, "required", true);
        this.checkValidatorResult(results, MIDDLE_NAME_FIELD, "required", true);
        this.checkValidatorResult(results, MIDDLE_NAME_FIELD, "int", false);
        this.checkNotRun(results, MIDDLE_NAME_FIELD, "positive");
        this.checkValidatorResult(results, LAST_NAME_FIELD, "required", false);
        this.checkNotRun(results, LAST_NAME_FIELD, "int");
    }

    private ValidatorResults validate(Object bean) throws ValidatorException {
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", bean);
        return validator.validate();
    }
}

