/*
 * Decompiled with CFR 0.152.
 */
package com.zzhoujay.html;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import com.zzhoujay.html.Kit;
import com.zzhoujay.html.style.ZBulletSpan;
import com.zzhoujay.html.style.ZCodeSpan;
import com.zzhoujay.html.style.ZIndentSpan;
import com.zzhoujay.html.style.ZQuoteSpan;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class HtmlToSpannedConverter
implements ContentHandler {
    private static final String TAG = "HtmlToSpannedConverter";
    private static final float[] HEADING_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    private static final Map<String, Integer> sColorMap = new HashMap<String, Integer>();
    private static Pattern sTextAlignPattern;
    private static Pattern sForegroundColorPattern;
    private static Pattern sBackgroundColorPattern;
    private static Pattern sTextDecorationPattern;
    private static Pattern sRgbColorPattern;
    private static Pattern sArgbColorPattern;
    private static Pattern sHexColorPattern;
    private static Pattern sTextIndentPattern;
    private String mSource;
    private XMLReader mReader;
    private SpannableStringBuilder mSpannableStringBuilder;
    private Html.ImageGetter mImageGetter;
    private Html.TagHandler mTagHandler;
    private int mFlags;

    HtmlToSpannedConverter(String source, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser, int flags) {
        this.mSource = source;
        this.mSpannableStringBuilder = new SpannableStringBuilder();
        this.mImageGetter = imageGetter;
        this.mTagHandler = tagHandler;
        this.mReader = parser;
        this.mFlags = flags;
    }

    private static Pattern getArgbColorPattern() {
        if (sArgbColorPattern == null) {
            sArgbColorPattern = Pattern.compile("\\s*rgba\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*([\\d.]+)\\b");
        }
        return sArgbColorPattern;
    }

    private static Pattern getHexColorPattern() {
        if (sHexColorPattern == null) {
            sHexColorPattern = Pattern.compile("\\s*(#[A-Za-z0-9]{6,8})");
        }
        return sHexColorPattern;
    }

    private static Pattern getRgbColorPattern() {
        if (sRgbColorPattern == null) {
            sRgbColorPattern = Pattern.compile("\\s*rgb\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\b");
        }
        return sRgbColorPattern;
    }

    private static Pattern getTextAlignPattern() {
        if (sTextAlignPattern == null) {
            sTextAlignPattern = Pattern.compile("(?:\\s+|\\A)text-align\\s*:\\s*(\\S*)\\b");
        }
        return sTextAlignPattern;
    }

    private static Pattern getForegroundColorPattern() {
        if (sForegroundColorPattern == null) {
            sForegroundColorPattern = Pattern.compile("(?:\\s+|\\A)color\\s*:\\s*(\\S*)\\b");
        }
        return sForegroundColorPattern;
    }

    private static Pattern getBackgroundColorPattern() {
        if (sBackgroundColorPattern == null) {
            sBackgroundColorPattern = Pattern.compile("(?:\\s+|\\A)background(?:-color)?\\s*:\\s*(\\S*)\\b");
        }
        return sBackgroundColorPattern;
    }

    private static Pattern getTextDecorationPattern() {
        if (sTextDecorationPattern == null) {
            sTextDecorationPattern = Pattern.compile("(?:\\s+|\\A)text-decoration\\s*:\\s*(\\S*)\\b");
        }
        return sTextDecorationPattern;
    }

    private static Pattern getTextIndentPattern() {
        if (sTextIndentPattern == null) {
            sTextIndentPattern = Pattern.compile("(?:\\s+|\\A)text-indent\\s*:\\s*(\\d*)px\\b");
        }
        return sTextIndentPattern;
    }

    private static void appendNewlines(Editable text, int minNewline) {
        int len = text.length();
        if (len == 0) {
            return;
        }
        int existingNewlines = 0;
        for (int i = len - 1; i >= 0 && text.charAt(i) == '\n'; --i) {
            ++existingNewlines;
        }
        for (int j = existingNewlines; j < minNewline; ++j) {
            text.append((CharSequence)"\n");
        }
    }

    private static void startBlockElement(Editable text, Attributes attributes, int margin) {
        String style;
        int len = text.length();
        if (margin > 0) {
            HtmlToSpannedConverter.appendNewlines(text, margin);
            HtmlToSpannedConverter.start(text, new Newline(margin));
        }
        if ((style = attributes.getValue("", "style")) != null) {
            Matcher m = HtmlToSpannedConverter.getTextAlignPattern().matcher(style);
            if (m.find()) {
                String alignment = m.group(1);
                if (alignment.equalsIgnoreCase("start")) {
                    HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_NORMAL));
                } else if (alignment.equalsIgnoreCase("center")) {
                    HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_CENTER));
                } else if (alignment.equalsIgnoreCase("end")) {
                    HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_OPPOSITE));
                }
            }
            if ((m = HtmlToSpannedConverter.getTextIndentPattern().matcher(style)).find()) {
                String textIndent = m.group(1);
                try {
                    int tab = Integer.valueOf(textIndent);
                    HtmlToSpannedConverter.start(text, new Indent(tab));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private static void endBlockElement(Editable text) {
        Alignment a;
        Indent indent;
        Newline n = HtmlToSpannedConverter.getLast((Spanned)text, Newline.class);
        if (n != null) {
            HtmlToSpannedConverter.appendNewlines(text, n.mNumNewlines);
            text.removeSpan((Object)n);
        }
        if ((indent = HtmlToSpannedConverter.getLast((Spanned)text, Indent.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, indent, new ZIndentSpan(indent.mIndentSize));
        }
        if ((a = HtmlToSpannedConverter.getLast((Spanned)text, Alignment.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, a, new AlignmentSpan.Standard(a.mAlignment));
        }
    }

    private static void handleBr(Editable text) {
        text.append('\n');
    }

    private static void endLi(Editable text) {
        HtmlToSpannedConverter.endCssStyle(text);
        HtmlToSpannedConverter.endBlockElement(text);
        HtmlToSpannedConverter.end(text, Bullet.class, (Object)new ZBulletSpan());
    }

    private static void endBlockquote(Editable text) {
        HtmlToSpannedConverter.endBlockElement(text);
        HtmlToSpannedConverter.end(text, Blockquote.class, (Object)new ZQuoteSpan());
    }

    private static void endHeading(Editable text) {
        Heading h = HtmlToSpannedConverter.getLast((Spanned)text, Heading.class);
        if (h != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, h, new RelativeSizeSpan(HEADING_SIZES[h.mLevel]), new StyleSpan(1));
        }
        HtmlToSpannedConverter.endBlockElement(text);
    }

    private static <T> T getLast(Spanned text, Class<T> kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        return (T)objs[objs.length - 1];
    }

    private static void setSpanFromMark(Spannable text, Object mark, Object ... spans) {
        int where = text.getSpanStart(mark);
        text.removeSpan(mark);
        int len = text.length();
        if (where != len) {
            for (Object span : spans) {
                text.setSpan(span, where, len, 33);
            }
        }
    }

    private static void start(Editable text, Object mark) {
        int len = text.length();
        text.setSpan(mark, len, len, 17);
    }

    private static void end(Editable text, Class kind, Object repl) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast((Spanned)text, kind);
        if (obj != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, obj, repl);
        }
    }

    private static void endCssStyle(Editable text) {
        Foreground f;
        Background b;
        Strikethrough s = HtmlToSpannedConverter.getLast((Spanned)text, Strikethrough.class);
        if (s != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, s, new StrikethroughSpan());
        }
        if ((b = HtmlToSpannedConverter.getLast((Spanned)text, Background.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, b, new BackgroundColorSpan(b.mBackgroundColor));
        }
        if ((f = HtmlToSpannedConverter.getLast((Spanned)text, Foreground.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, f, new ForegroundColorSpan(f.mForegroundColor));
        }
    }

    private static void startImg(Editable text, Attributes attributes, Html.ImageGetter img) {
        String src = attributes.getValue("", "src");
        Drawable d = null;
        if (img != null) {
            d = img.getDrawable(src);
        }
        if (d == null) {
            d = new ColorDrawable(-3355444);
            d.setBounds(0, 0, 100, 100);
        }
        int len = text.length();
        text.append((CharSequence)"\ufffc");
        text.setSpan((Object)new ImageSpan(d, src), len, text.length(), 33);
    }

    private static void endFont(Editable text) {
        Foreground foreground;
        Font font = HtmlToSpannedConverter.getLast((Spanned)text, Font.class);
        if (font != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, font, new TypefaceSpan(font.mFace));
        }
        if ((foreground = HtmlToSpannedConverter.getLast((Spanned)text, Foreground.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, foreground, new ForegroundColorSpan(foreground.mForegroundColor));
        }
    }

    private static void startA(Editable text, Attributes attributes) {
        String href = attributes.getValue("", "href");
        HtmlToSpannedConverter.start(text, new Href(href));
    }

    private static void endA(Editable text) {
        Href h = HtmlToSpannedConverter.getLast((Spanned)text, Href.class);
        if (h != null && h.mHref != null) {
            HtmlToSpannedConverter.setSpanFromMark((Spannable)text, h, new URLSpan(h.mHref));
        }
    }

    Spanned convert() {
        Object[] obj;
        this.mReader.setContentHandler(this);
        try {
            this.mReader.parse(new InputSource(new StringReader(this.mSource)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        for (Object anObj : obj = this.mSpannableStringBuilder.getSpans(0, this.mSpannableStringBuilder.length(), ParagraphStyle.class)) {
            int start = this.mSpannableStringBuilder.getSpanStart(anObj);
            int end = this.mSpannableStringBuilder.getSpanEnd(anObj);
            if (end - 2 >= 0 && this.mSpannableStringBuilder.charAt(end - 1) == '\n' && this.mSpannableStringBuilder.charAt(end - 2) == '\n') {
                --end;
            }
            if (end == start) {
                this.mSpannableStringBuilder.removeSpan(anObj);
                continue;
            }
            this.mSpannableStringBuilder.setSpan(anObj, start, end, 51);
        }
        return this.mSpannableStringBuilder;
    }

    private void handleStartTag(String tag, Attributes attributes) {
        if (!tag.equalsIgnoreCase("br")) {
            if (tag.equalsIgnoreCase("p")) {
                HtmlToSpannedConverter.startBlockElement((Editable)this.mSpannableStringBuilder, attributes, this.getMarginParagraph());
                this.startCssStyle((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("ul")) {
                HtmlToSpannedConverter.startBlockElement((Editable)this.mSpannableStringBuilder, attributes, this.getMarginList());
                this.startCssStyle((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("li")) {
                this.startLi((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("div")) {
                HtmlToSpannedConverter.startBlockElement((Editable)this.mSpannableStringBuilder, attributes, this.getMarginDiv());
                this.startCssStyle((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("span")) {
                this.startCssStyle((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("strong")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Bold());
            } else if (tag.equalsIgnoreCase("b")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Bold());
            } else if (tag.equalsIgnoreCase("em")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("cite")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("dfn")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("i")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("big")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Big());
            } else if (tag.equalsIgnoreCase("small")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Small());
            } else if (tag.equalsIgnoreCase("font")) {
                this.startFont((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("blockquote")) {
                this.startBlockquote((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("tt")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Monospace());
            } else if (tag.equalsIgnoreCase("a")) {
                HtmlToSpannedConverter.startA((Editable)this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("u")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Underline());
            } else if (tag.equalsIgnoreCase("del")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag.equalsIgnoreCase("s")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag.equalsIgnoreCase("strike")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Strikethrough());
            } else if (tag.equalsIgnoreCase("sup")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Super());
            } else if (tag.equalsIgnoreCase("sub")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Sub());
            } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
                this.startHeading((Editable)this.mSpannableStringBuilder, attributes, tag.charAt(1) - 49);
            } else if (tag.equalsIgnoreCase("img")) {
                HtmlToSpannedConverter.startImg((Editable)this.mSpannableStringBuilder, attributes, this.mImageGetter);
            } else if (tag.equalsIgnoreCase("code")) {
                HtmlToSpannedConverter.start((Editable)this.mSpannableStringBuilder, new Code());
            } else if (this.mTagHandler != null) {
                this.mTagHandler.handleTag(true, tag, (Editable)this.mSpannableStringBuilder, this.mReader);
            }
        }
    }

    private void handleEndTag(String tag) {
        if (tag.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("p")) {
            HtmlToSpannedConverter.endCssStyle((Editable)this.mSpannableStringBuilder);
            HtmlToSpannedConverter.endBlockElement((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("ul")) {
            HtmlToSpannedConverter.endCssStyle((Editable)this.mSpannableStringBuilder);
            HtmlToSpannedConverter.endBlockElement((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("li")) {
            HtmlToSpannedConverter.endLi((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("div")) {
            HtmlToSpannedConverter.endCssStyle((Editable)this.mSpannableStringBuilder);
            HtmlToSpannedConverter.endBlockElement((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("span")) {
            HtmlToSpannedConverter.endCssStyle((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("strong")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("b")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("em")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("cite")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("dfn")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("i")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("big")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Big.class, new RelativeSizeSpan(1.25f));
        } else if (tag.equalsIgnoreCase("small")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Small.class, new RelativeSizeSpan(0.8f));
        } else if (tag.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.endFont((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("blockquote")) {
            HtmlToSpannedConverter.endBlockquote((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("tt")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Monospace.class, new TypefaceSpan("monospace"));
        } else if (tag.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.endA((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("u")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Underline.class, new UnderlineSpan());
        } else if (tag.equalsIgnoreCase("del")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("s")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("strike")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("sup")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Super.class, new SuperscriptSpan());
        } else if (tag.equalsIgnoreCase("sub")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Sub.class, new SubscriptSpan());
        } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            HtmlToSpannedConverter.endHeading((Editable)this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("code")) {
            HtmlToSpannedConverter.end((Editable)this.mSpannableStringBuilder, Code.class, (Object)new ZCodeSpan());
        } else if (this.mTagHandler != null) {
            this.mTagHandler.handleTag(false, tag, (Editable)this.mSpannableStringBuilder, this.mReader);
        }
    }

    private int getMarginParagraph() {
        return this.getMargin(1);
    }

    private int getMarginHeading() {
        return this.getMargin(2);
    }

    private int getMarginListItem() {
        return this.getMargin(4);
    }

    private int getMarginList() {
        return this.getMargin(8);
    }

    private int getMarginDiv() {
        return this.getMargin(16);
    }

    private int getMarginBlockquote() {
        return this.getMargin(32);
    }

    private int getMargin(int flag) {
        if ((flag & this.mFlags) != 0) {
            return 1;
        }
        return 2;
    }

    private void startLi(Editable text, Attributes attributes) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginListItem());
        HtmlToSpannedConverter.start(text, new Bullet());
        this.startCssStyle(text, attributes);
    }

    private void startBlockquote(Editable text, Attributes attributes) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginBlockquote());
        HtmlToSpannedConverter.start(text, new Blockquote());
    }

    private void startHeading(Editable text, Attributes attributes, int level) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginHeading());
        HtmlToSpannedConverter.start(text, new Heading(level));
    }

    private void startCssStyle(Editable text, Attributes attributes) {
        String style = attributes.getValue("", "style");
        if (style != null) {
            String textDecoration;
            int c;
            Matcher m = HtmlToSpannedConverter.getForegroundColorPattern().matcher(style);
            if (m.find() && (c = this.getHtmlColor(m.group(1))) != -1) {
                HtmlToSpannedConverter.start(text, new Foreground(c | 0xFF000000));
            }
            if ((m = HtmlToSpannedConverter.getBackgroundColorPattern().matcher(style)).find() && (c = this.getHtmlColor(m.group(1))) != -1) {
                HtmlToSpannedConverter.start(text, new Background(c | 0xFF000000));
            }
            if ((m = HtmlToSpannedConverter.getTextDecorationPattern().matcher(style)).find() && (textDecoration = m.group(1)).equalsIgnoreCase("line-through")) {
                HtmlToSpannedConverter.start(text, new Strikethrough());
            }
        }
    }

    private void startFont(Editable text, Attributes attributes) {
        int c;
        String color = attributes.getValue("", "color");
        String face = attributes.getValue("", "face");
        if (!TextUtils.isEmpty((CharSequence)color) && (c = this.getHtmlColor(color)) != -1) {
            HtmlToSpannedConverter.start(text, new Foreground(c | 0xFF000000));
        }
        if (!TextUtils.isEmpty((CharSequence)face)) {
            HtmlToSpannedConverter.start(text, new Font(face));
        }
    }

    private int getHtmlColor(String color) {
        Integer i;
        if ((this.mFlags & 0x100) == 256 && (i = sColorMap.get(color.toLowerCase(Locale.US))) != null) {
            return i;
        }
        int htmlColor = Kit.getHtmlColor(color);
        if (htmlColor != -1) {
            return htmlColor;
        }
        try {
            Matcher rgbMatcher = HtmlToSpannedConverter.getRgbColorPattern().matcher(color);
            if (rgbMatcher.find()) {
                int r = Integer.valueOf(rgbMatcher.group(1));
                int g = Integer.valueOf(rgbMatcher.group(2));
                int b = Integer.valueOf(rgbMatcher.group(3));
                return Color.rgb((int)r, (int)g, (int)b);
            }
        }
        catch (Exception rgbMatcher) {
            // empty catch block
        }
        try {
            Matcher hexMatcher = HtmlToSpannedConverter.getHexColorPattern().matcher(color);
            if (hexMatcher.find()) {
                String hexColor = hexMatcher.group(1);
                return Color.parseColor((String)hexColor);
            }
        }
        catch (Exception hexMatcher) {
            // empty catch block
        }
        try {
            Matcher argbMatcher = HtmlToSpannedConverter.getArgbColorPattern().matcher(color);
            if (argbMatcher.find()) {
                int r = Integer.valueOf(argbMatcher.group(1));
                int g = Integer.valueOf(argbMatcher.group(2));
                int b = Integer.valueOf(argbMatcher.group(3));
                float a = Float.valueOf(argbMatcher.group(4)).floatValue();
                return Color.argb((int)((int)(a * 255.0f)), (int)r, (int)g, (int)b);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -16777216;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handleStartTag(localName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.mSpannableStringBuilder.length()) == 0 ? 10 : (int)this.mSpannableStringBuilder.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.mSpannableStringBuilder.append((CharSequence)sb);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    static {
        sColorMap.put("darkgray", -5658199);
        sColorMap.put("gray", -8355712);
        sColorMap.put("lightgray", -2894893);
        sColorMap.put("darkgrey", -5658199);
        sColorMap.put("grey", -8355712);
        sColorMap.put("lightgrey", -2894893);
        sColorMap.put("green", -16744448);
    }

    private static class Indent {
        private final int mIndentSize;

        private Indent(int mIndentSize) {
            this.mIndentSize = mIndentSize;
        }
    }

    private static class Alignment {
        private Layout.Alignment mAlignment;

        Alignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
        }
    }

    private static class Newline {
        private int mNumNewlines;

        Newline(int numNewlines) {
            this.mNumNewlines = numNewlines;
        }
    }

    private static class Heading {
        private int mLevel;

        Heading(int level) {
            this.mLevel = level;
        }
    }

    private static class Background {
        private int mBackgroundColor;

        Background(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
        }
    }

    private static class Foreground {
        private int mForegroundColor;

        Foreground(int foregroundColor) {
            this.mForegroundColor = foregroundColor;
        }
    }

    private static class Href {
        String mHref;

        Href(String href) {
            this.mHref = href;
        }
    }

    private static class Font {
        String mFace;

        Font(String face) {
            this.mFace = face;
        }
    }

    private static class Code {
        private Code() {
        }
    }

    private static class Bullet {
        private Bullet() {
        }
    }

    private static class Sub {
        private Sub() {
        }
    }

    private static class Super {
        private Super() {
        }
    }

    private static class Blockquote {
        private Blockquote() {
        }
    }

    private static class Monospace {
        private Monospace() {
        }
    }

    private static class Small {
        private Small() {
        }
    }

    private static class Big {
        private Big() {
        }
    }

    private static class Strikethrough {
        private Strikethrough() {
        }
    }

    private static class Underline {
        private Underline() {
        }
    }

    private static class Italic {
        private Italic() {
        }
    }

    private static class Bold {
        private Bold() {
        }
    }
}

