/*
 * Decompiled with CFR 0.152.
 */
package com.zxn.time;

import android.annotation.SuppressLint;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;

public class TimeUtils {
    @SuppressLint(value={"SimpleDateFormat"})
    private static final SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat();
    private static final int TIME_UNIT_SECOND = 1;
    private static final int TIME_UNIT_MINUTIUE = 60;
    private static final int TIME_UNIT_HOUR = 3600;
    private static final int TIME_UNIT_DAY = 86400;
    private static final int TIME_UNIT_YEAR = 31536000;
    @Deprecated
    private static SimpleDateFormat hourminuteFormat = new SimpleDateFormat("hh:mm");
    Long gg = 60000L;
    Long mmax = this.gg * 60L;
    Long hmax = this.mmax * 24L;
    Long dmax = this.hmax * 30L;

    public static boolean isPast(int year, int month, int date) {
        long inTime = TimeUtils.getTimeInMillis(year, month, date);
        return inTime <= System.currentTimeMillis();
    }

    public static long getTimeInMillis(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date);
        return calendar.getTimeInMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String formatDuration(int count, int inputUnitType, int outUnitType) {
        if (inputUnitType == 0) return "";
        if (inputUnitType == 1) {
            int totalMillis = count * 1000;
            int h = totalMillis / 3600000;
            int m = totalMillis % 3600000 / 60000;
            int s = totalMillis % 3600000 % 60000 / 1000;
            if (outUnitType == 1 || outUnitType == 20) return "";
            if (outUnitType == 30) {
                return h + "\u5c0f\u65f6" + m + "\u5206\u949f" + s + "\u79d2";
            }
            if (outUnitType != 4) return "";
        }
        if (inputUnitType == 2) {
            int totalMillis = count * 60000;
            int h = totalMillis / 3600000;
            int m = totalMillis % 3600000 / 60000;
            if (outUnitType == 1 || outUnitType == 20) return "";
            if (outUnitType == 30) {
                return h + "\u5c0f\u65f6" + m + "\u5206\u949f";
            }
            if (outUnitType != 4) return "";
        }
        if (inputUnitType != 3 && inputUnitType != 4 && inputUnitType != 5 && inputUnitType != 6 && inputUnitType != 7) return "";
        return "";
    }

    public static String changeTime(String time, String pattern, int hour, int minute) {
        Calendar calendar = Calendar.getInstance();
        long stamp = TimeUtils.timeToStamp(time, pattern);
        calendar.setTimeInMillis(stamp);
        calendar.set(11, hour);
        calendar.set(12, minute);
        mSimpleDateFormat.applyPattern(pattern);
        return mSimpleDateFormat.format(calendar.getTime());
    }

    public static String getTimeByCalendar(int year, int month, int date, String pattern) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date);
        mSimpleDateFormat.applyPattern(pattern);
        return mSimpleDateFormat.format(calendar.getTime());
    }

    @Deprecated
    public static String calculateTime(int dayCount, String pattern) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + dayCount);
        mSimpleDateFormat.applyPattern(pattern);
        return mSimpleDateFormat.format(calendar.getTime());
    }

    public static String calculateTime(int dayCount, String date, String pattern) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(TimeUtils.timeToStamp(date, pattern)));
        calendar.set(5, calendar.get(5) + dayCount);
        mSimpleDateFormat.applyPattern(pattern);
        return mSimpleDateFormat.format(calendar.getTime());
    }

    public static String currentTime(String pattern) {
        mSimpleDateFormat.applyPattern(pattern);
        return mSimpleDateFormat.format(new Date(System.currentTimeMillis()));
    }

    public static String timeToTime(String time, String oldPattern, String newPattern) {
        long stamp = TimeUtils.timeToStamp(time, oldPattern);
        return TimeUtils.stampToTime(stamp, newPattern);
    }

    public static boolean isZeroMinute(long stamp) {
        Date date = new Date(stamp);
        int minutes = date.getMinutes();
        return minutes == 0;
    }

    public static boolean isZeroTime(long stamp) {
        Date date = new Date(stamp);
        int hours = date.getHours();
        int minutes = date.getMinutes();
        int seconds = date.getSeconds();
        return hours == 0 && minutes == 0 && seconds == 0;
    }

    public static String stampToTime(long time, String patternType) {
        Date date = new Date(time);
        mSimpleDateFormat.applyPattern(patternType);
        String res = mSimpleDateFormat.format(date);
        return res;
    }

    public static long timeToStamp(String time, String patternType) {
        mSimpleDateFormat.applyPattern(patternType);
        Date date = null;
        try {
            date = mSimpleDateFormat.parse(time);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
        return date.getTime();
    }

    public static int getSeparatedDays(Date oldDate, Date newDate) {
        Calendar oldCalendar = Calendar.getInstance();
        oldCalendar.setTime(oldDate);
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.setTime(newDate);
        int oldDay = oldCalendar.get(6);
        int newDay = newCalendar.get(6);
        int oldYear = oldCalendar.get(1);
        int newYear = newCalendar.get(1);
        if (oldYear != newYear) {
            int timeDistance = 0;
            for (int i = oldYear; i < newYear; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (newDay - oldDay);
        }
        System.out.println("\u5224\u65adday2 - oldDay : " + (newDay - oldDay));
        return newDay - oldDay;
    }

    public static int getSeparatedDays(long oldStamp, long newStamp) {
        return TimeUtils.getSeparatedDays(new Date(oldStamp), new Date(newStamp));
    }

    public static String showTime(long elapsed) {
        String time = "1\u5206\u949f\u524d";
        if (elapsed > 86400L) {
            return String.format(Locale.CHINA, "%d\u5929\u524d", (int)(elapsed / 86400L));
        }
        if (elapsed > 3600L) {
            return String.format(Locale.CHINA, "%d\u5c0f\u65f6\u524d", (int)(elapsed / 3600L));
        }
        if (elapsed > 60L) {
            return String.format(Locale.CHINA, "%d\u5206\u949f\u524d", (int)(elapsed / 60L));
        }
        return time;
    }

    public static String showGameTime(long elapsed) {
        String time = "1\u5206\u949f\u524d";
        if (elapsed > 86400L) {
            return String.format(Locale.CHINA, "%d\u5929", (int)(elapsed / 86400L));
        }
        if (elapsed > 3600L) {
            return String.format(Locale.CHINA, "%d\u5c0f\u65f6", (int)(elapsed / 3600L));
        }
        if (elapsed > 60L) {
            return String.format(Locale.CHINA, "%d\u5206\u949f", (int)(elapsed / 60L));
        }
        return time;
    }

    @Deprecated
    public static String getDateToString(long time) {
        if ((time /= 1000L) < 60L) {
            return Math.max(0L, time) + "\u79d2";
        }
        if (time > 60L && time < 3600L) {
            int m = (int)(time / 60L);
            int s = (int)(time % 60L);
            return m + "\u5206\u949f" + s + "\u79d2";
        }
        if (time >= 3600L && time < 86400L) {
            int h = (int)(time / 3600L);
            int m = (int)(time % 3600L / 60L);
            int s = (int)(time % 3600L % 60L % 60L);
            return h + "\u5c0f\u65f6" + m + "\u5206\u949f" + s + "\u79d2";
        }
        int d = (int)(time / 86400L);
        int h = (int)(time % 86400L / 3600L);
        int m = (int)(time % 86400L % 3600L / 60L);
        int s = (int)(time % 86400L % 3600L % 60L % 60L);
        return d + "\u5929" + h + "\u5c0f\u65f6" + m + "\u5206\u949f" + s + "\u79d2";
    }

    public static String month2en(String month) {
        String en = "";
        int monthI = Integer.valueOf(month);
        if (monthI > 12) {
            en = "";
        } else if (monthI == 1) {
            en = "January";
        } else if (monthI == 2) {
            en = "February";
        } else if (monthI == 3) {
            en = "March";
        } else if (monthI == 4) {
            en = " April";
        } else if (monthI == 5) {
            en = "May";
        } else if (monthI == 6) {
            en = "June";
        } else if (monthI == 7) {
            en = "July";
        } else if (monthI == 8) {
            en = "August";
        } else if (monthI == 9) {
            en = " September";
        } else if (monthI == 10) {
            en = "October";
        } else if (monthI == 11) {
            en = "November";
        } else if (monthI == 12) {
            en = "December";
        }
        en = en.substring(0, 3);
        return en;
    }

    public static String timeParse(long duration) {
        String time = "";
        long minute = duration / 60L;
        long seconds = duration % 60L;
        time = time + minute + ":";
        if (seconds < 10L) {
            time = time + "0";
        }
        time = time + seconds;
        return time;
    }

    @Deprecated
    public static String stringForTime(long timeMs) {
        long totalSeconds = timeMs / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        StringBuilder mFormatBuilder = new StringBuilder();
        Formatter mFormatter = new Formatter(mFormatBuilder, Locale.getDefault());
        mFormatBuilder.setLength(0);
        if (hours > 0L) {
            return mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }
}

