/*
 * Decompiled with CFR 0.152.
 */
package com.zxn.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    private static final SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat();
    public static final String FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String formatNoSS = "yyyy-MM-dd HH:mm";
    public static final String formatNossSSSS = "yyyyMMddHHmmssSSS";
    public static final String formatNoTime = "yyyy-MM-dd";
    public static final String formatNoTime1 = "yyyyMMdd";
    public static final String formatAll = "yyyy-MM-dd HH:mm:ss";
    public static final String formatAll1 = "yyyyMMddHHmmss";
    public static SimpleDateFormat m = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());
    public static SimpleDateFormat m1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    public static SimpleDateFormat t = new SimpleDateFormat("HHmmss", Locale.getDefault());
    public static SimpleDateFormat t1 = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
    public static SimpleDateFormat n = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
    public static SimpleDateFormat n1 = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    public static SimpleDateFormat q = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    public static SimpleDateFormat q1 = new SimpleDateFormat("yyyy.MM.dd", Locale.getDefault());
    public static SimpleDateFormat q2 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5", Locale.getDefault());

    public static String formatTimeQ2(String payTime) throws ParseException {
        return q2.format(q.parse(payTime));
    }

    public static String formatTimeQ1(String payTime) throws ParseException {
        return q1.format(q.parse(payTime));
    }

    public static String formatTime(String payTime) throws ParseException {
        return m1.format(m.parse(payTime));
    }

    public static String formatTime_revert(String payTime) throws ParseException {
        return m.format(m1.parse(payTime));
    }

    public static String formatTime1(String payTime) throws ParseException {
        return n.format(n1.parse(payTime));
    }

    public static String formatTimeTo(String payTime) throws ParseException {
        return t.format(t1.parse(payTime));
    }

    public static Date str2Date(String str, String format) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.getDefault());
            date = sdf.parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Calendar str2Calendar(String str) {
        return DateUtils.str2Calendar(str, null);
    }

    public static Calendar str2Calendar(String str, String format) {
        Date date = DateUtils.str2Date(str, format);
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static long str2Long(String str, String format) {
        Date date = DateUtils.str2Date(str, format);
        if (date == null) {
            return 0L;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getTimeInMillis();
    }

    public static String date2Str(Calendar c, String format) {
        if (c == null) {
            return null;
        }
        return DateUtils.date2Str(c.getTime(), format);
    }

    public static String date2Str(Date d, String format) {
        if (d == null) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.getDefault());
        String s = sdf.format(d);
        return s;
    }

    public static String getCurDateStr() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        return c.get(1) + "-" + (c.get(2) + 1) + "-" + c.get(5) + "-" + c.get(11) + ":" + c.get(12) + ":" + c.get(13);
    }

    public static String getCurDateStr(String format) {
        Calendar c = Calendar.getInstance();
        return DateUtils.date2Str(c, format);
    }

    public static String getMillon(long time) {
        return DateUtils.transferLongToDate("yyyy-MM-dd HH:mm:ss", time);
    }

    public static String getDay(long time) {
        return new SimpleDateFormat(formatNoTime, Locale.getDefault()).format(time);
    }

    public static String getDay() {
        return new SimpleDateFormat(formatNoTime, Locale.getDefault()).format(System.currentTimeMillis());
    }

    public static String getTime(long time) {
        return new SimpleDateFormat("HH:mm", Locale.getDefault()).format(time);
    }

    public static String transferLongToDate(String dateFormat, Long millSec) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.getDefault());
        Date date = new Date(millSec);
        return sdf.format(date);
    }

    public static boolean isSameDate(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        boolean isSameYear = cal1.get(1) == cal2.get(1);
        boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
        boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
        return isSameDate;
    }

    public static boolean isToday(String dateText, String pattern) {
        mSimpleDateFormat.applyPattern(pattern);
        Calendar dateCalendar = Calendar.getInstance();
        try {
            dateCalendar.setTime(mSimpleDateFormat.parse(dateText));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int dateYear = dateCalendar.get(1);
        int dateMonth = dateCalendar.get(2);
        int dateDay = dateCalendar.get(5);
        Calendar calendar = Calendar.getInstance();
        int todayYear = calendar.get(1);
        int todayMonth = calendar.get(2);
        int todayDay = calendar.get(5);
        return dateYear == todayYear && dateMonth == todayMonth && dateDay == todayDay;
    }

    public static boolean isYesterday(String dateText, String pattern) {
        mSimpleDateFormat.applyPattern(pattern);
        Calendar dateCalendar = Calendar.getInstance();
        try {
            dateCalendar.setTime(mSimpleDateFormat.parse(dateText));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int dateYear = dateCalendar.get(1);
        int dateMonth = dateCalendar.get(2);
        int dateDay = dateCalendar.get(5);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        int yesterdayYear = calendar.get(1);
        int yesterdayMonth = calendar.get(2);
        int yesterdayDay = calendar.get(5);
        return dateYear == yesterdayYear && dateMonth == yesterdayMonth && dateDay == yesterdayDay;
    }

    public static String calculateDateByYear(int yearCount, String pattern) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calendar.get(1) + yearCount);
        mSimpleDateFormat.applyPattern(pattern);
        return mSimpleDateFormat.format(calendar.getTime());
    }

    public static String calculateDateByDay(int dayCount, String pattern) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + dayCount);
        mSimpleDateFormat.applyPattern(pattern);
        return mSimpleDateFormat.format(calendar.getTime());
    }

    public static boolean isSameMonth(String dateText, String pattern) {
        mSimpleDateFormat.applyPattern(pattern);
        Calendar dateCalendar = Calendar.getInstance();
        try {
            dateCalendar.setTime(mSimpleDateFormat.parse(dateText));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int dateMonth = dateCalendar.get(2);
        Calendar calendar = Calendar.getInstance();
        int todayMonth = calendar.get(2);
        return dateMonth == todayMonth;
    }

    public static boolean isSameDay(String dateText, String pattern) {
        mSimpleDateFormat.applyPattern(pattern);
        Calendar dateCalendar = Calendar.getInstance();
        try {
            dateCalendar.setTime(mSimpleDateFormat.parse(dateText));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int dateDay = dateCalendar.get(5);
        Calendar calendar = Calendar.getInstance();
        int todayDay = calendar.get(5);
        return dateDay == todayDay;
    }

    public static boolean isSameMonthDay(String dateText, String pattern) {
        return DateUtils.isSameDay(dateText, pattern) && DateUtils.isSameMonth(dateText, pattern);
    }
}

