/*
 * Decompiled with CFR 0.152.
 */
package com.zxn.expand;

import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class ExpandLayout
extends RelativeLayout {
    private View layoutView;
    private int viewHeight;
    private boolean isExpand;
    private long animationDuration;
    private boolean lock;

    public ExpandLayout(Context context) {
        this(context, null);
    }

    public ExpandLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpandLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        this.layoutView = this;
        this.isExpand = true;
        this.animationDuration = 300L;
        this.setViewDimensions();
    }

    public void initExpand(boolean isExpand) {
        this.isExpand = isExpand;
        this.setViewDimensions();
    }

    public void setAnimationDuration(long animationDuration) {
        this.animationDuration = animationDuration;
    }

    private void setViewDimensions() {
        this.layoutView.post(new Runnable(){

            @Override
            public void run() {
                if (ExpandLayout.this.viewHeight <= 0) {
                    ExpandLayout.this.viewHeight = ExpandLayout.this.layoutView.getMeasuredHeight();
                }
                ExpandLayout.setViewHeight(ExpandLayout.this.layoutView, ExpandLayout.this.isExpand ? ExpandLayout.this.viewHeight : 0);
            }
        });
    }

    public static void setViewHeight(View view, int height) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        params.height = height;
        view.requestLayout();
    }

    private void animateToggle(long animationDuration) {
        ValueAnimator heightAnimation = this.isExpand ? ValueAnimator.ofFloat((float[])new float[]{0.0f, this.viewHeight}) : ValueAnimator.ofFloat((float[])new float[]{this.viewHeight, 0.0f});
        heightAnimation.setDuration(animationDuration / 2L);
        heightAnimation.setStartDelay(animationDuration / 2L);
        heightAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (int)((Float)animation.getAnimatedValue()).floatValue();
                ExpandLayout.setViewHeight(ExpandLayout.this.layoutView, value);
                if (value == ExpandLayout.this.viewHeight || value == 0) {
                    ExpandLayout.this.lock = false;
                }
            }
        });
        heightAnimation.start();
        this.lock = true;
    }

    public boolean isExpand() {
        return this.isExpand;
    }

    public void collapse() {
        this.isExpand = false;
        this.animateToggle(this.animationDuration);
    }

    public void expand() {
        this.isExpand = true;
        this.animateToggle(this.animationDuration);
    }

    public void toggleExpand() {
        if (this.lock) {
            return;
        }
        if (this.isExpand) {
            this.collapse();
        } else {
            this.expand();
        }
    }
}

