/*
 * Decompiled with CFR 0.152.
 */
package com.zwonb.util;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.StringRes;
import com.zwonb.util.R;
import com.zwonb.util.UtilConfig;

public class YToast {
    private static Toast sToast;

    public static void show(CharSequence text) {
        YToast.initToast(text);
        if (sToast != null) {
            sToast.show();
        }
    }

    public static void show(@StringRes int resId) {
        YToast.initToast(resId);
        if (sToast != null) {
            sToast.show();
        }
    }

    @SuppressLint(value={"ShowToast"})
    private static void initToast(CharSequence text) {
        YToast.cancel();
        Application application = UtilConfig.sContext;
        if (application != null) {
            sToast = Toast.makeText((Context)application, (CharSequence)text, (int)0);
            if (Build.VERSION.SDK_INT <= 29) {
                View view = LayoutInflater.from((Context)application).inflate(R.layout.toast_layout, null);
                sToast.setView(view);
                sToast.setText(text);
            }
        }
    }

    @SuppressLint(value={"ShowToast"})
    private static void initToast(@StringRes int resId) {
        YToast.cancel();
        Application application = UtilConfig.sContext;
        if (application != null) {
            sToast = Toast.makeText((Context)application, (int)resId, (int)0);
            if (Build.VERSION.SDK_INT <= 29) {
                View view = LayoutInflater.from((Context)application).inflate(R.layout.toast_layout, null);
                sToast.setView(view);
                sToast.setText(resId);
            }
        }
    }

    private static void cancel() {
        if (sToast != null) {
            sToast.cancel();
            sToast = null;
        }
    }
}

