/*
 * Decompiled with CFR 0.152.
 */
package com.zwonb.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import androidx.core.content.FileProvider;
import com.zwonb.util.UtilConfig;
import com.zwonb.util.YToast;
import java.io.File;

public class YAppInfo {
    public static int getVersionCode() {
        try {
            PackageInfo packageInfo = UtilConfig.sContext.getPackageManager().getPackageInfo(UtilConfig.sContext.getPackageName(), 1);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            YToast.show("\u83b7\u53d6\u7248\u672c\u53f7\u5f02\u5e38");
            return -1;
        }
    }

    public static String getVersionName() {
        try {
            PackageInfo packageInfo = UtilConfig.sContext.getPackageManager().getPackageInfo(UtilConfig.sContext.getPackageName(), 1);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            YToast.show("\u83b7\u53d6\u7248\u672c\u540d\u5f02\u5e38");
            return "";
        }
    }

    public static String getPackageName() {
        return UtilConfig.sContext.getPackageName();
    }

    public static boolean hasInstallApk(String packageName) {
        PackageManager manager = UtilConfig.sContext.getPackageManager();
        try {
            ApplicationInfo info = Build.VERSION.SDK_INT >= 24 ? manager.getApplicationInfo(packageName, 8192) : manager.getApplicationInfo(packageName, 8192);
            return info != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void openApp(String packageName) {
        try {
            Intent intent = UtilConfig.sContext.getPackageManager().getLaunchIntentForPackage(packageName);
            if (intent != null) {
                intent.addFlags(0x10000000);
                UtilConfig.sContext.startActivity(intent);
            } else {
                YToast.show("\u672a\u5b89\u88c5\u6b64\u5e94\u7528");
            }
        }
        catch (Exception e) {
            YToast.show("\u672a\u5b89\u88c5\u6b64\u5e94\u7528");
        }
    }

    public static void installApk(File apkFile) {
        if (!apkFile.exists()) {
            YToast.show("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        Intent intent = YAppInfo.getIntent(apkFile);
        UtilConfig.sContext.startActivity(intent);
    }

    public static Intent getIntent(File apkFile) {
        Uri uri;
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(1);
            uri = FileProvider.getUriForFile((Context)UtilConfig.sContext, (String)(YAppInfo.getPackageName() + ".file_provider"), (File)apkFile);
        } else {
            uri = Uri.fromFile((File)apkFile);
        }
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        return intent;
    }
}

