package com.zwonb.util;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.annotation.StringRes;

/**
 * Toast 工具类
 *
 * @author zwonb
 * @date 2017/12/21
 */

public class YToast {

    private static Toast sToast;

    public static void show(CharSequence text) {
        initToast(text);
        if (sToast != null) {
            sToast.show();
        }
    }

    public static void show(@StringRes int resId) {
        initToast(resId);
        if (sToast != null) {
            sToast.show();
        }
    }

    @SuppressLint("ShowToast")
    private static void initToast(CharSequence text) {
        cancel();
        Application application = UtilConfig.sContext;
        if (application != null) {
            sToast = Toast.makeText(application, text, Toast.LENGTH_SHORT);
            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.Q) {
                View view = LayoutInflater.from(application).inflate(R.layout.toast_layout, null);
                sToast.setView(view);
                sToast.setText(text);
            }
        }
    }

    @SuppressLint("ShowToast")
    private static void initToast(@StringRes int resId) {
        cancel();
        Application application = UtilConfig.sContext;
        if (application != null) {
            sToast = Toast.makeText(application, resId, Toast.LENGTH_SHORT);
            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.Q) {
                View view = LayoutInflater.from(application).inflate(R.layout.toast_layout, null);
                sToast.setView(view);
                sToast.setText(resId);
            }
        }
    }

    private static void cancel() {
        if (sToast != null) {
            sToast.cancel();
            sToast = null;
        }
    }

}
