package com.zwonb.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;

/**
 * 网络相关
 *
 * @date 2017/12/21
 * @author zwonb
 */

public class YNetwork {

    /**
     * 检查网络是否可用
     */
    public static boolean networkIsAvailable() {
        ConnectivityManager service = (ConnectivityManager) UtilConfig.sContext.getSystemService(
                Context.CONNECTIVITY_SERVICE);
        if (service != null) {
            NetworkInfo networkInfo = service.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isAvailable();
            }
        }
        return false;
    }

    /**
     * 打开 WiFi
     */
    public static void openWiFi() {
        WifiManager manager = getWiFiManager();
        if (!manager.isWifiEnabled()) {
            if (!manager.setWifiEnabled(true)) {
                YToast.show("WiFi开启失败，请关闭网络共享或者飞行模式");
            }
        }
    }

    /**
     * 关闭 WiFi
     */
    public static void closeWiFi() {
        WifiManager manager = getWiFiManager();
        if (manager.isWifiEnabled()) {
            if (!manager.setWifiEnabled(false)) {
                YToast.show("WiFi关闭失败");
            }
        }
    }

    private static WifiManager getWiFiManager() {
        return (WifiManager) UtilConfig.sContext.getSystemService(Context.WIFI_SERVICE);
    }
}
