package com.zwonb.util;

import androidx.annotation.NonNull;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

/**
 * @author zwonb
 */

public class YDateTime {

    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    /**
     * 时间戳转日期
     */
    public static String getDateTime(long millisecond) {
        return getDate(millisecond, null, DATE_TIME_PATTERN);
    }

    /**
     * 时间戳转日期
     */
    public static String getDate(long millisecond, @NonNull String pattern) {
        return getDate(millisecond, null, pattern);
    }

    /**
     * 时间戳转日期
     *
     * @param timeZone 时区 (UTC+8:00 或 Asia/Shanghai)
     */
    public static String getDate(long millisecond, String timeZone, @NonNull String pattern) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
            if (timeZone != null) {
                dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            return dateFormat.format(millisecond);
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * 日期转时间戳
     */
    public static long getMillisecond(String dateTime) {
        return getMillisecond(dateTime, null, DATE_TIME_PATTERN);
    }

    /**
     * 日期转时间戳
     */
    public static long getMillisecond(String date, @NonNull String pattern) {
        return getMillisecond(date, null, pattern);
    }

    /**
     * 日期转时间戳
     * @param timeZone 时区 (UTC+8:00 或 Asia/Shanghai)
     */
    public static long getMillisecond(String date, String timeZone, @NonNull String pattern) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
            if (timeZone != null) {
                dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            return dateFormat.parse(date).getTime();
        } catch (Exception e) {
            return 0;
        }
    }

}
