/*
 * Decompiled with CFR 0.152.
 */
package com.zwonb.util;

import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.zwonb.util.UtilConfig;
import java.lang.reflect.Field;

public class YKeyboard {
    public static void hideSoftInput(View view) {
        InputMethodManager imm;
        if (view != null && (imm = (InputMethodManager)UtilConfig.sContext.getSystemService("input_method")) != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static void showSoftInput(View view) {
        InputMethodManager imm = (InputMethodManager)UtilConfig.sContext.getSystemService("input_method");
        if (imm == null || view == null) {
            return;
        }
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        imm.showSoftInput(view, 2);
    }

    public static void fixInputMethodManagerLeak(Context context) {
        String[] arr;
        if (context == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        for (String param : arr = new String[]{"mCurRootView", "mServedView", "mNextServedView"}) {
            try {
                Object obj;
                Field field = imm.getClass().getDeclaredField(param);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((obj = field.get(imm)) == null || !(obj instanceof View)) continue;
                View vGet = (View)obj;
                if (vGet.getContext() != context) break;
                field.set(imm, null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }
}

