package com.zwonb.util;

import android.annotation.SuppressLint;
import android.app.Application;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.annotation.StringRes;

/**
 * Toast 工具类
 *
 * @author zwonb
 * @date 2017/12/21
 */

public class YToast {

    private static Toast sToast;

    public static void show(CharSequence text) {
        if (initToast() != null) {
            sToast.setText(text);
            sToast.show();
        }
    }

    public static void show(@StringRes int resId) {
        if (initToast() != null) {
            sToast.setText(resId);
            sToast.show();
        }
    }

    @SuppressLint("InflateParams")
    @Nullable
    private static Toast initToast() {
        if (sToast != null) {
            sToast.cancel();
            sToast = null;
        }
        Application application = UtilConfig.sContext;
        if (application == null) {
            return null;
        }
        sToast = new Toast(application);
        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.Q) {
            View view = LayoutInflater.from(application).inflate(R.layout.toast_layout, null);
            sToast.setView(view);
        }
        sToast.setDuration(Toast.LENGTH_SHORT);
        return sToast;
    }

}
