package com.zwonb.util;

import android.content.Context;
import android.graphics.Point;
import android.util.TypedValue;
import android.view.WindowManager;

/**
 * 量度相关
 *
 * @date 2017/12/21
 * @author zwonb
 */

public class YDisplay {

    /**
     * dp2px
     */
    public static int getDP(float dp) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp,
                UtilConfig.sContext.getResources().getDisplayMetrics());
    }

    /**
     * 获取屏幕宽度
     */
    public static int getDisplayWidth() {
        WindowManager windowManager = (WindowManager) UtilConfig.sContext.getSystemService(
                Context.WINDOW_SERVICE);
        if (windowManager != null) {
            Point point = new Point();
            windowManager.getDefaultDisplay().getSize(point);
            return point.x;
        } else {
            return -1;
        }
    }
}
