/*
 * Decompiled with CFR 0.152.
 */
package com.zwonb.util;

import android.support.annotation.NonNull;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class YDateTime {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String getDateTime(long millisecond) {
        return YDateTime.getDate(millisecond, null, DATE_TIME_PATTERN);
    }

    public static String getDate(long millisecond, @NonNull String pattern) {
        return YDateTime.getDate(millisecond, null, pattern);
    }

    public static String getDate(long millisecond, String timeZone, @NonNull String pattern) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
            if (timeZone != null) {
                dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            return dateFormat.format(millisecond);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static long getMillisecond(String dateTime) {
        return YDateTime.getMillisecond(dateTime, null, DATE_TIME_PATTERN);
    }

    public static long getMillisecond(String date, @NonNull String pattern) {
        return YDateTime.getMillisecond(date, null, pattern);
    }

    public static long getMillisecond(String date, String timeZone, @NonNull String pattern) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
            if (timeZone != null) {
                dateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            return dateFormat.parse(date).getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

