package com.zwonb.util;

import android.content.Context;
import android.content.SharedPreferences;


/**
 * 存储本地一些值的工具类
 *
 * @date 2017/12/21
 * @author zwonb
 */

public class YSPUtil {

    public static final String NAME_CONFIG = "config";
    public static final String IMEI = "imei";

    /**
     * 退出登录可以清除的数据
     */
    public static final String NAME_USER = "user";
    public static final String PHONE = "phone";
    public static final String USER_PWD = "user_pwd";
    public static final String NAME = "name";
    public static final String UID = "uid";
    public static final String LOGIN_STATUS = "login_status";

    //----常用键值----start------------//

    /**
     * 获取IMEI
     */
    public static String getIMEI() {
        return (String) YSPUtil.getInstance().get(NAME_CONFIG, IMEI, "");
    }

    /**
     * 获取用户名(手机号)
     */
    public static String getPhone() {
        return ((String) YSPUtil.getInstance().get(NAME_USER, PHONE, ""));
    }

    /**
     * 获取用户密码
     */
    public static String getUserPWD() {
        return ((String) YSPUtil.getInstance().get(NAME_USER, USER_PWD, ""));
    }

    /**
     * 获取用户昵称(姓名)
     */
    public static String getName() {
        return ((String) YSPUtil.getInstance().get(NAME_USER, NAME, ""));
    }

    /**
     * 获取用户 UID
     */
    public static String getUid() {
        return ((String) YSPUtil.getInstance().get(NAME_USER, UID, ""));
    }

    /**
     * 获取登陆状态
     */
    public static boolean getLoginStatus() {
        return ((boolean) YSPUtil.getInstance().get(NAME_USER, LOGIN_STATUS, false));
    }

    public static void putIMEI(String imei) {
        YSPUtil.getInstance().put(NAME_CONFIG, IMEI, imei);
    }

    public static void putPhone(String phone) {
        YSPUtil.getInstance().put(NAME_USER, PHONE, phone);
    }

    public static void putUserPWD(String pwd) {
        YSPUtil.getInstance().put(NAME_USER, USER_PWD, pwd);
    }

    public static void putName(String name) {
        YSPUtil.getInstance().put(NAME_USER, NAME, name);
    }

    public static void putUid(String uid) {
        YSPUtil.getInstance().put(NAME_USER, UID, uid);
    }

    public static void putLoginStatus(boolean status) {
        YSPUtil.getInstance().put(NAME_USER, LOGIN_STATUS, status);
    }
    //----常用键值----end------------//

    private YSPUtil() {
    }

    public static YSPUtil getInstance() {
        return SingleHolder.INSTANCE;
    }

    private static class SingleHolder {
        private static final YSPUtil INSTANCE = new YSPUtil();
    }

    public YSPUtil put(String name, String key, Object value) {
        if (value instanceof String) {
            YSPUtil.getPreferences(name).edit().putString(key, (String) value).apply();
        } else if (value instanceof Integer) {
            YSPUtil.getPreferences(name).edit().putInt(key, (Integer) value).apply();
        } else if (value instanceof Boolean) {
            YSPUtil.getPreferences(name).edit().putBoolean(key, (Boolean) value).apply();
        } else if (value instanceof Long) {
            YSPUtil.getPreferences(name).edit().putLong(key, (Long) value).apply();
        }
        return this;
    }

    public Object get(String name, String key, Object defValue) {
        if (defValue instanceof String) {
            return YSPUtil.getPreferences(name).getString(key, (String) defValue);
        } else if (defValue instanceof Integer) {
            return YSPUtil.getPreferences(name).getInt(key, (Integer) defValue);
        } else if (defValue instanceof Boolean) {
            return YSPUtil.getPreferences(name).getBoolean(key, (Boolean) defValue);
        } else if (defValue instanceof Long) {
            return YSPUtil.getPreferences(name).getLong(key, (Long) defValue);
        }
        return null;
    }

    /**
     * 删除某个key
     * @param name 文件的名字
     * @param key 对应的 key
     * @return YSPUtil
     */
    public YSPUtil remove(String name, String key) {
        YSPUtil.getPreferences(name).edit().remove(key).apply();
        return this;
    }

    /**
     * 删除文件 name 下的所有 key
     * @param name 文件的名字
     * @return YSPUtil
     */
    public YSPUtil clear(String name) {
        YSPUtil.getPreferences(name).edit().clear().apply();
        return this;
    }

    public static SharedPreferences getPreferences(String name) {
        return UtilConfig.sContext.getSharedPreferences(name, Context.MODE_PRIVATE);
    }

}
