package com.zwonb.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.content.FileProvider;

import java.io.File;

/**
 * 获取 App 信息
 *
 * @author zwonb
 * @date 2017/12/21
 */

public class YAppInfo {

    /**
     * 获取当前程序版本号
     */
    public static int getVersionCode() {
        try {
            PackageInfo packageInfo = UtilConfig.sContext.getPackageManager().getPackageInfo(
                    UtilConfig.sContext.getPackageName(), PackageManager.GET_ACTIVITIES);
            return packageInfo.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            YToast.show("获取版本号异常");
            return -1;
        }
    }

    /**
     * 获取当前程序版本名
     */
    public static String getVersionName() {
        try {
            PackageInfo packageInfo = UtilConfig.sContext.getPackageManager().getPackageInfo(
                    UtilConfig.sContext.getPackageName(), PackageManager.GET_ACTIVITIES);
            return packageInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            YToast.show("获取版本名异常");
            return "";
        }
    }

    /**
     * 获取当前程序包名
     */
    public static String getPackageName() {
        return UtilConfig.sContext.getPackageName();
    }

    /**
     * 是否安装了此 App
     */
    public static boolean hasInstallApk(String packageName) {
        PackageManager manager = UtilConfig.sContext.getPackageManager();
        try {
            ApplicationInfo info;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                info = manager.getApplicationInfo(packageName, PackageManager.MATCH_UNINSTALLED_PACKAGES);
            } else {
                info = manager.getApplicationInfo(packageName, PackageManager.GET_UNINSTALLED_PACKAGES);
            }
            return info != null;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 打开 app
     *
     * @param packageName 包名
     */
    public static void openApp(String packageName) {
        try {
            Intent intent = UtilConfig.sContext.getPackageManager()
                    .getLaunchIntentForPackage(packageName);
            if (intent != null) {
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                UtilConfig.sContext.startActivity(intent);
            } else {
                YToast.show("未安装此应用");
            }
        } catch (Exception e) {
            YToast.show("未安装此应用");
        }
    }

    /**
     * 安装 apk
     */
    public static void installApk(File apkFile) {
        if (!apkFile.exists()) {
            YToast.show("文件不存在");
            return;
        }
        Intent intent = getIntent(apkFile);
        UtilConfig.sContext.startActivity(intent);
    }

    /**
     * file_provider 这个 uri 共享已经在升级库里面做了处理了
     * 所以直接拿来用就行了
     */
    public static Intent getIntent(File apkFile) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        Uri uri;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
            uri = FileProvider.getUriForFile(UtilConfig.sContext,
                    getPackageName() + ".file_provider", apkFile);
        } else {
            uri = Uri.fromFile(apkFile);
        }
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        return intent;
    }

}
