package com.zwonb.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

/**
 * 网络相关
 *
 * @date 2017/12/21
 * @author zwonb
 */

public class YNetwork {

    /**
     * 检查网络是否可用
     */
    public static boolean networkIsAvailable() {
        ConnectivityManager service = (ConnectivityManager) UtilConfig.sContext.getSystemService(
                Context.CONNECTIVITY_SERVICE);
        if (service != null) {
            NetworkInfo networkInfo = service.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isAvailable();
            }
        }
        return false;
    }
}
