package com.zwonb.util;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

/**
 * 获取 App 信息
 *
 * @date 2017/12/21
 * @author zwonb
 */

public class YAppInfo {

    /**
     * 获取当前程序版本号
     */
    public static int getVersionCode() {
        try {
            PackageInfo packageInfo = UtilConfig.sContext.getPackageManager().getPackageInfo(
                    UtilConfig.sContext.getPackageName(), PackageManager.GET_ACTIVITIES);
            return packageInfo.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            YToast.show("获取版本号异常");
            return -1;
        }
    }

    /**
     * 获取当前程序版本名
     */
    public static String getVersionName() {
        try {
            PackageInfo packageInfo = UtilConfig.sContext.getPackageManager().getPackageInfo(
                    UtilConfig.sContext.getPackageName(), PackageManager.GET_ACTIVITIES);
            return packageInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            YToast.show("获取版本名异常");
            return "";
        }
    }

}
