package com.zwonb.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresPermission;
import android.telephony.TelephonyManager;

import static android.Manifest.permission.READ_PHONE_STATE;

/**
 * 手机信息相关
 *
 * @author zwonb
 */

public class YPhone {

    @SuppressLint("HardwareIds")
    @RequiresPermission(READ_PHONE_STATE)
    public static String getIMEI() {
        TelephonyManager tm = (TelephonyManager) UtilConfig.sContext.
                getSystemService(Context.TELEPHONY_SERVICE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            return tm != null ? tm.getImei() : "";
        } else {
            return tm != null ? tm.getDeviceId() : "";
        }
    }
}
