package com.zwonb.util;

import android.content.res.AssetManager;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * 解析 assets 里面的文件
 *
 * @author zwonb
 * @date 2018/2/9
 */

public class YAssteParse {

    /**
     * @param fileName asstes 文件夹里面的文件名字
     */
    @Nullable
    @WorkerThread
    public static String getFileString(String fileName) {
        AssetManager assets = UtilConfig.sContext.getAssets();
        try {
            BufferedReader bf = new BufferedReader(new InputStreamReader(assets.open(fileName)));
            StringBuilder stringBuilder = new StringBuilder();
            String line;
            for (; ; ) {
                line = bf.readLine();
                if (line == null) {
                    break;
                }
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}
