/*
 * Decompiled with CFR 0.152.
 */
package com.zwonb.util;

import android.content.SharedPreferences;
import com.zwonb.util.UtilConfig;

public class YSPUtil {
    public static final String NAME_CONFIG = "config";
    public static final String IMEI = "imei";
    public static final String NAME_USER = "user";
    public static final String PHONE = "phone";
    public static final String USER_PWD = "user_pwd";
    public static final String NAME = "name";
    public static final String UID = "uid";

    public static String getIMEI() {
        return (String)YSPUtil.getInstance().get(NAME_CONFIG, IMEI, "");
    }

    public static String getPhone() {
        return (String)YSPUtil.getInstance().get(NAME_USER, PHONE, "");
    }

    public static String getUserPWD() {
        return (String)YSPUtil.getInstance().get(NAME_USER, USER_PWD, "");
    }

    public static String getName() {
        return (String)YSPUtil.getInstance().get(NAME_USER, NAME, "");
    }

    public static String getUid() {
        return (String)YSPUtil.getInstance().get(NAME_USER, UID, "");
    }

    public static void putIMEI(String imei) {
        YSPUtil.getInstance().put(NAME_CONFIG, IMEI, imei);
    }

    public static void putPhone(String phone) {
        YSPUtil.getInstance().put(NAME_USER, PHONE, phone);
    }

    public static void putUserPWD(String pwd) {
        YSPUtil.getInstance().put(NAME_USER, USER_PWD, pwd);
    }

    public static void putName(String name) {
        YSPUtil.getInstance().put(NAME_USER, NAME, name);
    }

    public static void putUid(String uid) {
        YSPUtil.getInstance().put(NAME_USER, UID, uid);
    }

    private YSPUtil() {
    }

    public static YSPUtil getInstance() {
        return SingleHolder.INSTANCE;
    }

    public YSPUtil put(String name, String key, Object value) {
        if (value instanceof String) {
            YSPUtil.getPreferences(name).edit().putString(key, (String)value).apply();
        } else if (value instanceof Integer) {
            YSPUtil.getPreferences(name).edit().putInt(key, ((Integer)value).intValue()).apply();
        } else if (value instanceof Boolean) {
            YSPUtil.getPreferences(name).edit().putBoolean(key, ((Boolean)value).booleanValue()).apply();
        } else if (value instanceof Long) {
            YSPUtil.getPreferences(name).edit().putLong(key, ((Long)value).longValue()).apply();
        }
        return this;
    }

    public Object get(String name, String key, Object defValue) {
        if (defValue instanceof String) {
            return YSPUtil.getPreferences(name).getString(key, (String)defValue);
        }
        if (defValue instanceof Integer) {
            return YSPUtil.getPreferences(name).getInt(key, ((Integer)defValue).intValue());
        }
        if (defValue instanceof Boolean) {
            return YSPUtil.getPreferences(name).getBoolean(key, ((Boolean)defValue).booleanValue());
        }
        if (defValue instanceof Long) {
            return YSPUtil.getPreferences(name).getLong(key, ((Long)defValue).longValue());
        }
        return null;
    }

    public YSPUtil remove(String name, String key) {
        YSPUtil.getPreferences(name).edit().remove(key).apply();
        return this;
    }

    public YSPUtil clear(String name) {
        YSPUtil.getPreferences(name).edit().clear().apply();
        return this;
    }

    public static SharedPreferences getPreferences(String name) {
        return UtilConfig.sApplication.getSharedPreferences(name, 0);
    }

    private static class SingleHolder {
        private static final YSPUtil INSTANCE = new YSPUtil();

        private SingleHolder() {
        }
    }
}

