package com.zwonb.util;

import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

/**
 * 软键盘相关
 * Created by zwonb on 2018/3/8.
 */

public class YKeyboard {

    // 隐藏软键盘
    public static void hideSoftInput(View view) {
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) UtilConfig.sApplication
                    .getSystemService(Context.INPUT_METHOD_SERVICE);
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
    }

    // 显示软键盘
    public static void showSoftInput(final View view) {
        InputMethodManager imm = (InputMethodManager) UtilConfig.sApplication.
                getSystemService(Context.INPUT_METHOD_SERVICE);
        if (imm == null || view == null) return;
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        imm.showSoftInput(view, InputMethodManager.SHOW_FORCED);
    }

}
