package com.zwonb.util;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.widget.Toast;

/**
 * 获取 App 信息
 */

public class YAppInfo {

    /**
     * 获取当前程序版本号
     */
    public static int getVersionCode() {
        try {
            PackageInfo packageInfo = UtilConfig.sApplication.getPackageManager().getPackageInfo(
                    UtilConfig.sApplication.getPackageName(), PackageManager.GET_ACTIVITIES);
            return packageInfo.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            Toast.makeText(UtilConfig.sApplication, "获取版本号异常", Toast.LENGTH_SHORT).show();
            return 0;
        }
    }

    /**
     * 获取当前程序版本名
     */
    public static String getVersionName() {
        try {
            PackageInfo packageInfo = UtilConfig.sApplication.getPackageManager().getPackageInfo(
                    UtilConfig.sApplication.getPackageName(), PackageManager.GET_ACTIVITIES);
            return packageInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            Toast.makeText(UtilConfig.sApplication, "获取版本名异常", Toast.LENGTH_SHORT).show();
            return "";
        }
    }

}
