package com.zwonb.util;

import android.content.Context;
import android.content.SharedPreferences;


/**
 * 存储本地一些值的工具类
 * Created by zwonb on 2018/3/23.
 */

public class YSPUtil {

    public static final String NAME_CONFIG = "config";
    public static final String IMEI = "imei";

    // 退出登录可以清除的数据
    public static final String NAME_USER = "user";
    public static final String USER_NAME = "user_name";
    public static final String USER_PWD = "user_pwd";

    // 获取IMEI
    public static String getIMEI() {
        return (String) YSPUtil.getInstance().get(NAME_CONFIG, IMEI, "");
    }

    // 获取用户名
    public static String getUserName() {
        return ((String) YSPUtil.getInstance().get(NAME_USER, USER_NAME, ""));
    }

    // 获取用户密码
    public static String getUserPWD() {
        return ((String) YSPUtil.getInstance().get(NAME_USER, USER_PWD, ""));
    }

    // 存储IMEI
    public static void putIMEI(String imei) {
        YSPUtil.getInstance().put(NAME_CONFIG, IMEI, imei);
    }

    // 存储用户名
    public static void putUserName(String userName) {
        YSPUtil.getInstance().put(NAME_USER, USER_NAME, userName);
    }

    // 存储用户密码
    public static void putUserPWD(String pwd) {
        YSPUtil.getInstance().put(NAME_USER, USER_PWD, pwd);
    }

    private YSPUtil() {
    }

    public static YSPUtil getInstance() {
        return SingleHolder.INSTANCE;
    }

    private static class SingleHolder {
        private static final YSPUtil INSTANCE = new YSPUtil();
    }

    public YSPUtil put(String name, String key, Object value) {
        if (value instanceof String) {
            YSPUtil.getPreferences(name).edit().putString(key, (String) value).apply();
        } else if (value instanceof Integer) {
            YSPUtil.getPreferences(name).edit().putInt(key, (Integer) value).apply();
        } else if (value instanceof Boolean) {
            YSPUtil.getPreferences(name).edit().putBoolean(key, (Boolean) value).apply();
        } else if (value instanceof Long) {
            YSPUtil.getPreferences(name).edit().putLong(key, (Long) value).apply();
        }
        return this;
    }

    public Object get(String name, String key, Object defValue) {
        if (defValue instanceof String) {
            return YSPUtil.getPreferences(name).getString(key, (String) defValue);
        } else if (defValue instanceof Integer) {
            return YSPUtil.getPreferences(name).getInt(key, (Integer) defValue);
        } else if (defValue instanceof Boolean) {
            return YSPUtil.getPreferences(name).getBoolean(key, (Boolean) defValue);
        } else if (defValue instanceof Long) {
            return YSPUtil.getPreferences(name).getLong(key, (Long) defValue);
        }
        return null;
    }

    // 删除某个key
    public YSPUtil remove(String name, String key) {
        YSPUtil.getPreferences(name).edit().remove(key).apply();
        return this;
    }

    // 删除name下的所有key
    public YSPUtil clear(String name) {
        YSPUtil.getPreferences(name).edit().clear().apply();
        return this;
    }

    public static SharedPreferences getPreferences(String name) {
        return UtilConfig.sApplication.getSharedPreferences(name, Context.MODE_PRIVATE);
    }

}
