package com.zwonb.util;

import android.content.Context;
import android.graphics.Point;
import android.util.TypedValue;
import android.view.WindowManager;

/**
 * 量度相关
 * Created by zwonb on 2018/3/4.
 */

public class YDisplay {

    // dp2px
    public static int getDP(int dp) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp,
                UtilConfig.sApplication.getResources().getDisplayMetrics());
    }

    // 获取屏幕宽度
    public static int getDisplayWidth() {
        WindowManager windowManager = (WindowManager) UtilConfig.sApplication.getSystemService(Context.WINDOW_SERVICE);
        if (windowManager != null) {
            Point point = new Point();
            windowManager.getDefaultDisplay().getSize(point);
            return point.x;
        } else {
            return -1;
        }
    }
}
