/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.AuthorizationMandate;

public class PaymentMethodAuthorizationRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_GATEWAY_ID = "gateway_id";
    @SerializedName(value="gateway_id")
    private String gatewayId;
    public static final String SERIALIZED_NAME_GATEWAY_OPTIONS = "gateway_options";
    @SerializedName(value="gateway_options")
    private Map<String, String> gatewayOptions = null;
    public static final String SERIALIZED_NAME_GATEWAY_ORDER_ID = "gateway_order_id";
    @SerializedName(value="gateway_order_id")
    private String gatewayOrderId;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR = "statement_descriptor";
    @SerializedName(value="statement_descriptor")
    private String statementDescriptor;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR_PHONE = "statement_descriptor_phone";
    @SerializedName(value="statement_descriptor_phone")
    private String statementDescriptorPhone;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private AuthorizationMandate mandate;

    public PaymentMethodAuthorizationRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="A customer account identifier. Either `account_id` or `account_number` is required.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PaymentMethodAuthorizationRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RC-00000011", value="A Human-readable customer account identifier. Either `account_id` or `account_number` is required.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PaymentMethodAuthorizationRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Amount to be authorized.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PaymentMethodAuthorizationRequest gatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093d07ae636bb017ae97518762aa3", value="Identifier of the payment gateway that Zuora will use to authorize the payments that are made with this payment method. If you do not set this field, Zuora will use one of the following payment gateways instead: The default payment gateway of the customer account that owns the payment method, if the payment method is associated with a customer account or the default payment gateway of your Zuora tenant.")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public PaymentMethodAuthorizationRequest gatewayOptions(Map<String, String> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
        return this;
    }

    public PaymentMethodAuthorizationRequest putGatewayOptionsItem(String key, String gatewayOptionsItem) {
        if (this.gatewayOptions == null) {
            this.gatewayOptions = new HashMap<String, String>();
        }
        this.gatewayOptions.put(key, gatewayOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="A hash containing gateway-specific parameters.")
    public Map<String, String> getGatewayOptions() {
        return this.gatewayOptions;
    }

    public void setGatewayOptions(Map<String, String> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    public PaymentMethodAuthorizationRequest gatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A merchant-specified natural key value that can be passed to the electronic payment gateway when a payment is created. If not specified, the payment number will be passed in instead. Gateways check duplicates on the gateway order ID to ensure that the merchant do not accidentally enter the same transaction twice. This ID can also be used to do reconciliation and tie the payment to a natural key in external systems. The source of this ID varies by merchant. Some merchants use their shopping cart order IDs, and others use something different. Merchants use this ID to track transactions in their eCommerce systems. When you create a payment for capturing the authorized funds, it is highly recommended to pass in the `gateway_order_id` that you used when authorizing the funds by using the Create authorization operation, together with the `authorization_id` field.")
    public String getGatewayOrderId() {
        return this.gatewayOrderId;
    }

    public void setGatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
    }

    public PaymentMethodAuthorizationRequest statementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public PaymentMethodAuthorizationRequest statementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptorPhone() {
        return this.statementDescriptorPhone;
    }

    public void setStatementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
    }

    public PaymentMethodAuthorizationRequest mandate(AuthorizationMandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AuthorizationMandate getMandate() {
        return this.mandate;
    }

    public void setMandate(AuthorizationMandate mandate) {
        this.mandate = mandate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest = (PaymentMethodAuthorizationRequest)o;
        return Objects.equals(this.accountId, paymentMethodAuthorizationRequest.accountId) && Objects.equals(this.accountNumber, paymentMethodAuthorizationRequest.accountNumber) && Objects.equals(this.amount, paymentMethodAuthorizationRequest.amount) && Objects.equals(this.gatewayId, paymentMethodAuthorizationRequest.gatewayId) && Objects.equals(this.gatewayOptions, paymentMethodAuthorizationRequest.gatewayOptions) && Objects.equals(this.gatewayOrderId, paymentMethodAuthorizationRequest.gatewayOrderId) && Objects.equals(this.statementDescriptor, paymentMethodAuthorizationRequest.statementDescriptor) && Objects.equals(this.statementDescriptorPhone, paymentMethodAuthorizationRequest.statementDescriptorPhone) && Objects.equals(this.mandate, paymentMethodAuthorizationRequest.mandate);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountNumber, this.amount, this.gatewayId, this.gatewayOptions, this.gatewayOrderId, this.statementDescriptor, this.statementDescriptorPhone, this.mandate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodAuthorizationRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    gatewayId: ").append(this.toIndentedString(this.gatewayId)).append("\n");
        sb.append("    gatewayOptions: ").append(this.toIndentedString(this.gatewayOptions)).append("\n");
        sb.append("    gatewayOrderId: ").append(this.toIndentedString(this.gatewayOrderId)).append("\n");
        sb.append("    statementDescriptor: ").append(this.toIndentedString(this.statementDescriptor)).append("\n");
        sb.append("    statementDescriptorPhone: ").append(this.toIndentedString(this.statementDescriptorPhone)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

