/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

public class AccountPreviewRequest {
    public static final String SERIALIZED_NAME_EXCLUDE = "exclude";
    @SerializedName(value="exclude")
    private ExcludeEnum exclude;
    public static final String SERIALIZED_NAME_INCLUDE_DRAFT_ITEMS = "include_draft_items";
    @SerializedName(value="include_draft_items")
    private Boolean includeDraftItems;
    public static final String SERIALIZED_NAME_INCLUDE_EVERGREEN_SUBSCRIPTIONS = "include_evergreen_subscriptions";
    @SerializedName(value="include_evergreen_subscriptions")
    private Boolean includeEvergreenSubscriptions;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;

    public AccountPreviewRequest exclude(ExcludeEnum exclude) {
        this.exclude = exclude;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Any combination of one-time, recurring, and usage.")
    public ExcludeEnum getExclude() {
        return this.exclude;
    }

    public void setExclude(ExcludeEnum exclude) {
        this.exclude = exclude;
    }

    public AccountPreviewRequest includeDraftItems(Boolean includeDraftItems) {
        this.includeDraftItems = includeDraftItems;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to include items in the draft status.")
    public Boolean getIncludeDraftItems() {
        return this.includeDraftItems;
    }

    public void setIncludeDraftItems(Boolean includeDraftItems) {
        this.includeDraftItems = includeDraftItems;
    }

    public AccountPreviewRequest includeEvergreenSubscriptions(Boolean includeEvergreenSubscriptions) {
        this.includeEvergreenSubscriptions = includeEvergreenSubscriptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to include evergreen subscriptions.")
    public Boolean getIncludeEvergreenSubscriptions() {
        return this.includeEvergreenSubscriptions;
    }

    public void setIncludeEvergreenSubscriptions(Boolean includeEvergreenSubscriptions) {
        this.includeEvergreenSubscriptions = includeEvergreenSubscriptions;
    }

    public AccountPreviewRequest targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", required=true, value="The target date is used to determine which charges to bill. All unbilled charges as of or prior to the target date are included. Zuora automatically keeps track of all charges that need to be billed and that have not been billed prior to the target date.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountPreviewRequest accountPreviewRequest = (AccountPreviewRequest)o;
        return Objects.equals((Object)this.exclude, (Object)accountPreviewRequest.exclude) && Objects.equals(this.includeDraftItems, accountPreviewRequest.includeDraftItems) && Objects.equals(this.includeEvergreenSubscriptions, accountPreviewRequest.includeEvergreenSubscriptions) && Objects.equals(this.targetDate, accountPreviewRequest.targetDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exclude, this.includeDraftItems, this.includeEvergreenSubscriptions, this.targetDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountPreviewRequest {\n");
        sb.append("    exclude: ").append(this.toIndentedString((Object)this.exclude)).append("\n");
        sb.append("    includeDraftItems: ").append(this.toIndentedString(this.includeDraftItems)).append("\n");
        sb.append("    includeEvergreenSubscriptions: ").append(this.toIndentedString(this.includeEvergreenSubscriptions)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExcludeEnum {
        ONE_TIME("one_time"),
        RECURRING("recurring"),
        USAGE("usage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ExcludeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExcludeEnum fromValue(String value) {
            for (ExcludeEnum b : ExcludeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ExcludeEnum> {
            public void write(JsonWriter jsonWriter, ExcludeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ExcludeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExcludeEnum.fromValue(value);
            }
        }
    }
}

