/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="If the `type` of the payment method is `card`, this hash contains details about the Credit Card payment method. When providing a card number, you must meet the requirements for PCI compliance. We strongly recommend using Zuora's [Payment Pages 2.0](https://knowledgecenter.zuora.com/Billing/Billing_and_Payments/LA_Hosted_Payment_Pages/B_Payment_Pages_2.0) instead of interacting with this API directly.")
public class CardUpdate {
    public static final String SERIALIZED_NAME_EXPIRY_MONTH = "expiry_month";
    @SerializedName(value="expiry_month")
    private BigDecimal expiryMonth;
    public static final String SERIALIZED_NAME_EXPIRY_YEAR = "expiry_year";
    @SerializedName(value="expiry_year")
    private BigDecimal expiryYear;
    public static final String SERIALIZED_NAME_SECURITY_CODE = "security_code";
    @SerializedName(value="security_code")
    private String securityCode;

    public CardUpdate expiryMonth(BigDecimal expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="One- or two-digit expiration month (1-12) of the credit card.")
    public BigDecimal getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(BigDecimal expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public CardUpdate expiryYear(BigDecimal expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two- or four-digit number representing the card's expiration year.")
    public BigDecimal getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(BigDecimal expiryYear) {
        this.expiryYear = expiryYear;
    }

    public CardUpdate securityCode(String securityCode) {
        this.securityCode = securityCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Card security code. It is highly recommended to always include this value.")
    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardUpdate cardUpdate = (CardUpdate)o;
        return Objects.equals(this.expiryMonth, cardUpdate.expiryMonth) && Objects.equals(this.expiryYear, cardUpdate.expiryYear) && Objects.equals(this.securityCode, cardUpdate.securityCode);
    }

    public int hashCode() {
        return Objects.hash(this.expiryMonth, this.expiryYear, this.securityCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardUpdate {\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    securityCode: ").append(this.toIndentedString(this.securityCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

