/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ApplyUnapplyCreditMemo;
import org.openapitools.client.model.CreditMemo;
import org.openapitools.client.model.CreditMemoCreateRequest;
import org.openapitools.client.model.CreditMemoItemListResponse;
import org.openapitools.client.model.CreditMemoListResponse;
import org.openapitools.client.model.CreditMemoPatchRequest;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;

public class CreditMemosApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CreditMemosApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CreditMemosApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call applyCreditMemoCall(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApplyUnapplyCreditMemo localVarPostBody = applyUnapplyCreditMemo;
        String localVarPath = "/credit_memos/{credit_memo_id}/apply".replace("{credit_memo_id}", this.localVarApiClient.escapeString(creditMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyCreditMemoValidateBeforeCall(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoId' when calling applyCreditMemo(Async)");
        }
        if (applyUnapplyCreditMemo == null) {
            throw new ApiException("Missing the required parameter 'applyUnapplyCreditMemo' when calling applyCreditMemo(Async)");
        }
        return this.applyCreditMemoCall(creditMemoId, applyUnapplyCreditMemo, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> applyCreditMemoWithHttpInfo(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.applyCreditMemoValidateBeforeCall(creditMemoId, applyUnapplyCreditMemo, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call applyCreditMemoAsync(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.applyCreditMemoValidateBeforeCall(creditMemoId, applyUnapplyCreditMemo, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ApplyCreditMemoParams applyCreditMemoParams(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo) {
        return new ApplyCreditMemoParams(creditMemoId, applyUnapplyCreditMemo);
    }

    public CreditMemo applyCreditMemo(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo) throws ApiException {
        ApplyCreditMemoParams params = new ApplyCreditMemoParams(creditMemoId, applyUnapplyCreditMemo);
        return this.executeApplyCreditMemoAPICall(params).getData();
    }

    public CreditMemo applyCreditMemo(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> expand) throws ApiException {
        ApplyCreditMemoParams params = new ApplyCreditMemoParams(creditMemoId, applyUnapplyCreditMemo);
        params.expand(expand);
        return this.executeApplyCreditMemoAPICall(params).getData();
    }

    public CreditMemo applyCreditMemo(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> expand, Headers headers) throws ApiException {
        ApplyCreditMemoParams params = new ApplyCreditMemoParams(creditMemoId, applyUnapplyCreditMemo).expand(expand).headers(headers);
        return this.executeApplyCreditMemoAPICall(params).getData();
    }

    public CreditMemo apply(ApplyCreditMemoParams params) throws ApiException {
        return this.executeApplyCreditMemoAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> applyWithHttpInfo(ApplyCreditMemoParams params) throws ApiException {
        return this.executeApplyCreditMemoAPICall(params);
    }

    ApiResponse<CreditMemo> executeApplyCreditMemoAPICall(ApplyCreditMemoParams params) throws ApiException {
        return this.applyCreditMemoWithHttpInfo(params.creditMemoId, params.applyUnapplyCreditMemo, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call cancelCreditMemoCall(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credit_memos/{credit_memo_id}/cancel".replace("{credit_memo_id}", this.localVarApiClient.escapeString(creditMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelCreditMemoValidateBeforeCall(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoId' when calling cancelCreditMemo(Async)");
        }
        return this.cancelCreditMemoCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> cancelCreditMemoWithHttpInfo(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelCreditMemoValidateBeforeCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelCreditMemoAsync(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.cancelCreditMemoValidateBeforeCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelCreditMemoParams cancelCreditMemoParams(String creditMemoId) {
        return new CancelCreditMemoParams(creditMemoId);
    }

    public CreditMemo cancelCreditMemo(String creditMemoId) throws ApiException {
        CancelCreditMemoParams params = new CancelCreditMemoParams(creditMemoId);
        return this.executeCancelCreditMemoAPICall(params).getData();
    }

    public CreditMemo cancelCreditMemo(String creditMemoId, List<String> expand) throws ApiException {
        CancelCreditMemoParams params = new CancelCreditMemoParams(creditMemoId);
        params.expand(expand);
        return this.executeCancelCreditMemoAPICall(params).getData();
    }

    public CreditMemo cancelCreditMemo(String creditMemoId, List<String> expand, Headers headers) throws ApiException {
        CancelCreditMemoParams params = new CancelCreditMemoParams(creditMemoId).expand(expand).headers(headers);
        return this.executeCancelCreditMemoAPICall(params).getData();
    }

    public CreditMemo cancel(CancelCreditMemoParams params) throws ApiException {
        return this.executeCancelCreditMemoAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> cancelWithHttpInfo(CancelCreditMemoParams params) throws ApiException {
        return this.executeCancelCreditMemoAPICall(params);
    }

    ApiResponse<CreditMemo> executeCancelCreditMemoAPICall(CancelCreditMemoParams params) throws ApiException {
        return this.cancelCreditMemoWithHttpInfo(params.creditMemoId, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call createCreditMemoCall(CreditMemoCreateRequest creditMemoCreateRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreditMemoCreateRequest localVarPostBody = creditMemoCreateRequest;
        String localVarPath = "/credit_memos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCreditMemoValidateBeforeCall(CreditMemoCreateRequest creditMemoCreateRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'creditMemoCreateRequest' when calling createCreditMemo(Async)");
        }
        return this.createCreditMemoCall(creditMemoCreateRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> createCreditMemoWithHttpInfo(CreditMemoCreateRequest creditMemoCreateRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createCreditMemoValidateBeforeCall(creditMemoCreateRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createCreditMemoAsync(CreditMemoCreateRequest creditMemoCreateRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.createCreditMemoValidateBeforeCall(creditMemoCreateRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateCreditMemoParams createCreditMemoParams(CreditMemoCreateRequest creditMemoCreateRequest) {
        return new CreateCreditMemoParams(creditMemoCreateRequest);
    }

    public CreditMemo createCreditMemo(CreditMemoCreateRequest creditMemoCreateRequest) throws ApiException {
        CreateCreditMemoParams params = new CreateCreditMemoParams(creditMemoCreateRequest);
        return this.executeCreateCreditMemoAPICall(params).getData();
    }

    public CreditMemo createCreditMemo(CreditMemoCreateRequest creditMemoCreateRequest, List<String> expand) throws ApiException {
        CreateCreditMemoParams params = new CreateCreditMemoParams(creditMemoCreateRequest);
        params.expand(expand);
        return this.executeCreateCreditMemoAPICall(params).getData();
    }

    public CreditMemo createCreditMemo(CreditMemoCreateRequest creditMemoCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateCreditMemoParams params = new CreateCreditMemoParams(creditMemoCreateRequest).expand(expand).headers(headers);
        return this.executeCreateCreditMemoAPICall(params).getData();
    }

    public CreditMemo create(CreateCreditMemoParams params) throws ApiException {
        return this.executeCreateCreditMemoAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> createWithHttpInfo(CreateCreditMemoParams params) throws ApiException {
        return this.executeCreateCreditMemoAPICall(params);
    }

    ApiResponse<CreditMemo> executeCreateCreditMemoAPICall(CreateCreditMemoParams params) throws ApiException {
        return this.createCreditMemoWithHttpInfo(params.creditMemoCreateRequest, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call deleteCreditMemoCall(String creditMemoId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credit_memos/{credit_memo_id}".replace("{credit_memo_id}", this.localVarApiClient.escapeString(creditMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCreditMemoValidateBeforeCall(String creditMemoId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoId' when calling deleteCreditMemo(Async)");
        }
        return this.deleteCreditMemoCall(creditMemoId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteCreditMemoWithHttpInfo(String creditMemoId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteCreditMemoValidateBeforeCall(creditMemoId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteCreditMemoAsync(String creditMemoId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCreditMemoValidateBeforeCall(creditMemoId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteCreditMemoParams deleteCreditMemoParams(String creditMemoId) {
        return new DeleteCreditMemoParams(creditMemoId);
    }

    public void deleteCreditMemo(String creditMemoId) throws ApiException {
        DeleteCreditMemoParams params = new DeleteCreditMemoParams(creditMemoId);
        this.executeDeleteCreditMemoAPICall(params);
    }

    public void deleteCreditMemo(String creditMemoId, Headers headers) throws ApiException {
        DeleteCreditMemoParams params = new DeleteCreditMemoParams(creditMemoId).headers(headers);
        this.executeDeleteCreditMemoAPICall(params);
    }

    public void delete(DeleteCreditMemoParams params) throws ApiException {
        this.executeDeleteCreditMemoAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteCreditMemoParams params) throws ApiException {
        return this.executeDeleteCreditMemoAPICall(params);
    }

    ApiResponse<Void> executeDeleteCreditMemoAPICall(DeleteCreditMemoParams params) throws ApiException {
        return this.deleteCreditMemoWithHttpInfo(params.creditMemoId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getCreditMemoCall(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credit_memos/{credit_memo_id}".replace("{credit_memo_id}", this.localVarApiClient.escapeString(creditMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoValidateBeforeCall(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoId' when calling getCreditMemo(Async)");
        }
        return this.getCreditMemoCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> getCreditMemoWithHttpInfo(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoValidateBeforeCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoAsync(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoValidateBeforeCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoParams getCreditMemoParams(String creditMemoId) {
        return new GetCreditMemoParams(creditMemoId);
    }

    public CreditMemo getCreditMemo(String creditMemoId) throws ApiException {
        GetCreditMemoParams params = new GetCreditMemoParams(creditMemoId);
        return this.executeGetCreditMemoAPICall(params).getData();
    }

    public CreditMemo getCreditMemo(String creditMemoId, List<String> expand) throws ApiException {
        GetCreditMemoParams params = new GetCreditMemoParams(creditMemoId);
        params.expand(expand);
        return this.executeGetCreditMemoAPICall(params).getData();
    }

    public CreditMemo getCreditMemo(String creditMemoId, List<String> expand, Headers headers) throws ApiException {
        GetCreditMemoParams params = new GetCreditMemoParams(creditMemoId).expand(expand).headers(headers);
        return this.executeGetCreditMemoAPICall(params).getData();
    }

    public CreditMemo get(GetCreditMemoParams params) throws ApiException {
        return this.executeGetCreditMemoAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> getWithHttpInfo(GetCreditMemoParams params) throws ApiException {
        return this.executeGetCreditMemoAPICall(params);
    }

    ApiResponse<CreditMemo> executeGetCreditMemoAPICall(GetCreditMemoParams params) throws ApiException {
        return this.getCreditMemoWithHttpInfo(params.creditMemoId, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getCreditMemoItemsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> creditMemoItemFields, List<String> taxationItemsFields, List<String> creditMemoFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credit_memo_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_item.fields[]", creditMemoItemFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoItemsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> creditMemoItemFields, List<String> taxationItemsFields, List<String> creditMemoFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getCreditMemoItemsCall(cursor, expand, filter, sort, pageSize, fields, creditMemoItemFields, taxationItemsFields, creditMemoFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemoItemListResponse> getCreditMemoItemsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> creditMemoItemFields, List<String> taxationItemsFields, List<String> creditMemoFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, creditMemoItemFields, taxationItemsFields, creditMemoFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoItemListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoItemsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> creditMemoItemFields, List<String> taxationItemsFields, List<String> creditMemoFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemoItemListResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, creditMemoItemFields, taxationItemsFields, creditMemoFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoItemListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoItemsParams getCreditMemoItemsParams() {
        return new GetCreditMemoItemsParams();
    }

    public CreditMemoItemListResponse getCreditMemoItems() throws ApiException {
        GetCreditMemoItemsParams params = new GetCreditMemoItemsParams();
        return this.executeGetCreditMemoItemsAPICall(params).getData();
    }

    public CreditMemoItemListResponse getCreditMemoItems(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetCreditMemoItemsParams params = new GetCreditMemoItemsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetCreditMemoItemsAPICall(params).getData();
    }

    public CreditMemoItemListResponse getCreditMemoItems(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetCreditMemoItemsParams params = new GetCreditMemoItemsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetCreditMemoItemsAPICall(params).getData();
    }

    public CreditMemoItemListResponse list(GetCreditMemoItemsParams params) throws ApiException {
        return this.executeGetCreditMemoItemsAPICall(params).getData();
    }

    public ApiResponse<CreditMemoItemListResponse> listWithHttpInfo(GetCreditMemoItemsParams params) throws ApiException {
        return this.executeGetCreditMemoItemsAPICall(params);
    }

    ApiResponse<CreditMemoItemListResponse> executeGetCreditMemoItemsAPICall(GetCreditMemoItemsParams params) throws ApiException {
        return this.getCreditMemoItemsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.creditMemoItemFields, params.taxationItemsFields, params.creditMemoFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getCreditMemosCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credit_memos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemosValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getCreditMemosCall(cursor, expand, filter, sort, pageSize, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemoListResponse> getCreditMemosWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemosValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemosAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemoListResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemosValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemosParams getCreditMemosParams() {
        return new GetCreditMemosParams();
    }

    public CreditMemoListResponse getCreditMemos() throws ApiException {
        GetCreditMemosParams params = new GetCreditMemosParams();
        return this.executeGetCreditMemosAPICall(params).getData();
    }

    public CreditMemoListResponse getCreditMemos(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetCreditMemosParams params = new GetCreditMemosParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetCreditMemosAPICall(params).getData();
    }

    public CreditMemoListResponse getCreditMemos(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetCreditMemosParams params = new GetCreditMemosParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetCreditMemosAPICall(params).getData();
    }

    public CreditMemoListResponse list(GetCreditMemosParams params) throws ApiException {
        return this.executeGetCreditMemosAPICall(params).getData();
    }

    public ApiResponse<CreditMemoListResponse> listWithHttpInfo(GetCreditMemosParams params) throws ApiException {
        return this.executeGetCreditMemosAPICall(params);
    }

    ApiResponse<CreditMemoListResponse> executeGetCreditMemosAPICall(GetCreditMemosParams params) throws ApiException {
        return this.getCreditMemosWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call patchCreditMemoCall(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreditMemoPatchRequest localVarPostBody = creditMemoPatchRequest;
        String localVarPath = "/credit_memos/{credit_memo_id}".replace("{credit_memo_id}", this.localVarApiClient.escapeString(creditMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchCreditMemoValidateBeforeCall(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoId' when calling patchCreditMemo(Async)");
        }
        if (creditMemoPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'creditMemoPatchRequest' when calling patchCreditMemo(Async)");
        }
        return this.patchCreditMemoCall(creditMemoId, creditMemoPatchRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> patchCreditMemoWithHttpInfo(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.patchCreditMemoValidateBeforeCall(creditMemoId, creditMemoPatchRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call patchCreditMemoAsync(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.patchCreditMemoValidateBeforeCall(creditMemoId, creditMemoPatchRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PatchCreditMemoParams patchCreditMemoParams(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest) {
        return new PatchCreditMemoParams(creditMemoId, creditMemoPatchRequest);
    }

    public CreditMemo patchCreditMemo(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest) throws ApiException {
        PatchCreditMemoParams params = new PatchCreditMemoParams(creditMemoId, creditMemoPatchRequest);
        return this.executePatchCreditMemoAPICall(params).getData();
    }

    public CreditMemo patchCreditMemo(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest, List<String> expand) throws ApiException {
        PatchCreditMemoParams params = new PatchCreditMemoParams(creditMemoId, creditMemoPatchRequest);
        params.expand(expand);
        return this.executePatchCreditMemoAPICall(params).getData();
    }

    public CreditMemo patchCreditMemo(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest, List<String> expand, Headers headers) throws ApiException {
        PatchCreditMemoParams params = new PatchCreditMemoParams(creditMemoId, creditMemoPatchRequest).expand(expand).headers(headers);
        return this.executePatchCreditMemoAPICall(params).getData();
    }

    public CreditMemo update(PatchCreditMemoParams params) throws ApiException {
        return this.executePatchCreditMemoAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> updateWithHttpInfo(PatchCreditMemoParams params) throws ApiException {
        return this.executePatchCreditMemoAPICall(params);
    }

    ApiResponse<CreditMemo> executePatchCreditMemoAPICall(PatchCreditMemoParams params) throws ApiException {
        return this.patchCreditMemoWithHttpInfo(params.creditMemoId, params.creditMemoPatchRequest, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call postCreditMemoCall(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credit_memos/{credit_memo_id}/post".replace("{credit_memo_id}", this.localVarApiClient.escapeString(creditMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postCreditMemoValidateBeforeCall(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoId' when calling postCreditMemo(Async)");
        }
        return this.postCreditMemoCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> postCreditMemoWithHttpInfo(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postCreditMemoValidateBeforeCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call postCreditMemoAsync(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.postCreditMemoValidateBeforeCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostCreditMemoParams postCreditMemoParams(String creditMemoId) {
        return new PostCreditMemoParams(creditMemoId);
    }

    public CreditMemo postCreditMemo(String creditMemoId) throws ApiException {
        PostCreditMemoParams params = new PostCreditMemoParams(creditMemoId);
        return this.executePostCreditMemoAPICall(params).getData();
    }

    public CreditMemo postCreditMemo(String creditMemoId, List<String> expand) throws ApiException {
        PostCreditMemoParams params = new PostCreditMemoParams(creditMemoId);
        params.expand(expand);
        return this.executePostCreditMemoAPICall(params).getData();
    }

    public CreditMemo postCreditMemo(String creditMemoId, List<String> expand, Headers headers) throws ApiException {
        PostCreditMemoParams params = new PostCreditMemoParams(creditMemoId).expand(expand).headers(headers);
        return this.executePostCreditMemoAPICall(params).getData();
    }

    public CreditMemo post(PostCreditMemoParams params) throws ApiException {
        return this.executePostCreditMemoAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> postWithHttpInfo(PostCreditMemoParams params) throws ApiException {
        return this.executePostCreditMemoAPICall(params);
    }

    ApiResponse<CreditMemo> executePostCreditMemoAPICall(PostCreditMemoParams params) throws ApiException {
        return this.postCreditMemoWithHttpInfo(params.creditMemoId, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call unapplyCreditMemoCall(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApplyUnapplyCreditMemo localVarPostBody = applyUnapplyCreditMemo;
        String localVarPath = "/credit_memos/{credit_memo_id}/unapply".replace("{credit_memo_id}", this.localVarApiClient.escapeString(creditMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unapplyCreditMemoValidateBeforeCall(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoId' when calling unapplyCreditMemo(Async)");
        }
        if (applyUnapplyCreditMemo == null) {
            throw new ApiException("Missing the required parameter 'applyUnapplyCreditMemo' when calling unapplyCreditMemo(Async)");
        }
        return this.unapplyCreditMemoCall(creditMemoId, applyUnapplyCreditMemo, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> unapplyCreditMemoWithHttpInfo(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unapplyCreditMemoValidateBeforeCall(creditMemoId, applyUnapplyCreditMemo, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unapplyCreditMemoAsync(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.unapplyCreditMemoValidateBeforeCall(creditMemoId, applyUnapplyCreditMemo, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnapplyCreditMemoParams unapplyCreditMemoParams(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo) {
        return new UnapplyCreditMemoParams(creditMemoId, applyUnapplyCreditMemo);
    }

    public CreditMemo unapplyCreditMemo(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo) throws ApiException {
        UnapplyCreditMemoParams params = new UnapplyCreditMemoParams(creditMemoId, applyUnapplyCreditMemo);
        return this.executeUnapplyCreditMemoAPICall(params).getData();
    }

    public CreditMemo unapplyCreditMemo(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> expand) throws ApiException {
        UnapplyCreditMemoParams params = new UnapplyCreditMemoParams(creditMemoId, applyUnapplyCreditMemo);
        params.expand(expand);
        return this.executeUnapplyCreditMemoAPICall(params).getData();
    }

    public CreditMemo unapplyCreditMemo(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo, List<String> expand, Headers headers) throws ApiException {
        UnapplyCreditMemoParams params = new UnapplyCreditMemoParams(creditMemoId, applyUnapplyCreditMemo).expand(expand).headers(headers);
        return this.executeUnapplyCreditMemoAPICall(params).getData();
    }

    public CreditMemo unapply(UnapplyCreditMemoParams params) throws ApiException {
        return this.executeUnapplyCreditMemoAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> unapplyWithHttpInfo(UnapplyCreditMemoParams params) throws ApiException {
        return this.executeUnapplyCreditMemoAPICall(params);
    }

    ApiResponse<CreditMemo> executeUnapplyCreditMemoAPICall(UnapplyCreditMemoParams params) throws ApiException {
        return this.unapplyCreditMemoWithHttpInfo(params.creditMemoId, params.applyUnapplyCreditMemo, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call unpostCreditMemoCall(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credit_memos/{credit_memo_id}/unpost".replace("{credit_memo_id}", this.localVarApiClient.escapeString(creditMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unpostCreditMemoValidateBeforeCall(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoId' when calling unpostCreditMemo(Async)");
        }
        return this.unpostCreditMemoCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> unpostCreditMemoWithHttpInfo(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unpostCreditMemoValidateBeforeCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unpostCreditMemoAsync(String creditMemoId, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.unpostCreditMemoValidateBeforeCall(creditMemoId, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnpostCreditMemoParams unpostCreditMemoParams(String creditMemoId) {
        return new UnpostCreditMemoParams(creditMemoId);
    }

    public CreditMemo unpostCreditMemo(String creditMemoId) throws ApiException {
        UnpostCreditMemoParams params = new UnpostCreditMemoParams(creditMemoId);
        return this.executeUnpostCreditMemoAPICall(params).getData();
    }

    public CreditMemo unpostCreditMemo(String creditMemoId, List<String> expand) throws ApiException {
        UnpostCreditMemoParams params = new UnpostCreditMemoParams(creditMemoId);
        params.expand(expand);
        return this.executeUnpostCreditMemoAPICall(params).getData();
    }

    public CreditMemo unpostCreditMemo(String creditMemoId, List<String> expand, Headers headers) throws ApiException {
        UnpostCreditMemoParams params = new UnpostCreditMemoParams(creditMemoId).expand(expand).headers(headers);
        return this.executeUnpostCreditMemoAPICall(params).getData();
    }

    public CreditMemo unpost(UnpostCreditMemoParams params) throws ApiException {
        return this.executeUnpostCreditMemoAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> unpostWithHttpInfo(UnpostCreditMemoParams params) throws ApiException {
        return this.executeUnpostCreditMemoAPICall(params);
    }

    ApiResponse<CreditMemo> executeUnpostCreditMemoAPICall(UnpostCreditMemoParams params) throws ApiException {
        return this.unpostCreditMemoWithHttpInfo(params.creditMemoId, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    public static class UnpostCreditMemoParams {
        private final String creditMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public UnpostCreditMemoParams(String creditMemoId) {
            this.creditMemoId = creditMemoId;
        }

        public UnpostCreditMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UnpostCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UnpostCreditMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UnpostCreditMemoParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public UnpostCreditMemoParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public UnpostCreditMemoParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public UnpostCreditMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public UnpostCreditMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UnpostCreditMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public UnpostCreditMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UnpostCreditMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UnpostCreditMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class UnapplyCreditMemoParams {
        private final String creditMemoId;
        private final ApplyUnapplyCreditMemo applyUnapplyCreditMemo;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public UnapplyCreditMemoParams(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo) {
            this.creditMemoId = creditMemoId;
            this.applyUnapplyCreditMemo = applyUnapplyCreditMemo;
        }

        public UnapplyCreditMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UnapplyCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UnapplyCreditMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UnapplyCreditMemoParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public UnapplyCreditMemoParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public UnapplyCreditMemoParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public UnapplyCreditMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public UnapplyCreditMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UnapplyCreditMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public UnapplyCreditMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UnapplyCreditMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UnapplyCreditMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PostCreditMemoParams {
        private final String creditMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public PostCreditMemoParams(String creditMemoId) {
            this.creditMemoId = creditMemoId;
        }

        public PostCreditMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PostCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PostCreditMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PostCreditMemoParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public PostCreditMemoParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public PostCreditMemoParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public PostCreditMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PostCreditMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PostCreditMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PostCreditMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PostCreditMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PostCreditMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PatchCreditMemoParams {
        private final String creditMemoId;
        private final CreditMemoPatchRequest creditMemoPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public PatchCreditMemoParams(String creditMemoId, CreditMemoPatchRequest creditMemoPatchRequest) {
            this.creditMemoId = creditMemoId;
            this.creditMemoPatchRequest = creditMemoPatchRequest;
        }

        public PatchCreditMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PatchCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PatchCreditMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PatchCreditMemoParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public PatchCreditMemoParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public PatchCreditMemoParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public PatchCreditMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PatchCreditMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PatchCreditMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PatchCreditMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PatchCreditMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PatchCreditMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetCreditMemosParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetCreditMemosParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetCreditMemosParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetCreditMemosParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetCreditMemosParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetCreditMemosParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetCreditMemosParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetCreditMemosParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetCreditMemosParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetCreditMemosParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public GetCreditMemosParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public GetCreditMemosParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public GetCreditMemosParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetCreditMemosParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetCreditMemosParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }
    }

    public static class GetCreditMemoItemsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> creditMemoItemFields;
        private List<String> taxationItemsFields;
        private List<String> creditMemoFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetCreditMemoItemsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetCreditMemoItemsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetCreditMemoItemsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetCreditMemoItemsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetCreditMemoItemsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetCreditMemoItemsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetCreditMemoItemsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetCreditMemoItemsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetCreditMemoItemsParams creditMemoItemFields(List<String> creditMemoItemFields) {
            this.creditMemoItemFields = creditMemoItemFields;
            return this;
        }

        public GetCreditMemoItemsParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetCreditMemoItemsParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }
    }

    public static class GetCreditMemoParams {
        private final String creditMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetCreditMemoParams(String creditMemoId) {
            this.creditMemoId = creditMemoId;
        }

        public GetCreditMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetCreditMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetCreditMemoParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public GetCreditMemoParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public GetCreditMemoParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public GetCreditMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetCreditMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetCreditMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetCreditMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetCreditMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetCreditMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteCreditMemoParams {
        private final String creditMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public DeleteCreditMemoParams(String creditMemoId) {
            this.creditMemoId = creditMemoId;
        }

        public DeleteCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateCreditMemoParams {
        private final CreditMemoCreateRequest creditMemoCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CreateCreditMemoParams(CreditMemoCreateRequest creditMemoCreateRequest) {
            this.creditMemoCreateRequest = creditMemoCreateRequest;
        }

        public CreateCreditMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateCreditMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateCreditMemoParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public CreateCreditMemoParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public CreateCreditMemoParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public CreateCreditMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public CreateCreditMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreateCreditMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CreateCreditMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateCreditMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateCreditMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelCreditMemoParams {
        private final String creditMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CancelCreditMemoParams(String creditMemoId) {
            this.creditMemoId = creditMemoId;
        }

        public CancelCreditMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelCreditMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelCreditMemoParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public CancelCreditMemoParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public CancelCreditMemoParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public CancelCreditMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public CancelCreditMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CancelCreditMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CancelCreditMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelCreditMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelCreditMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class ApplyCreditMemoParams {
        private final String creditMemoId;
        private final ApplyUnapplyCreditMemo applyUnapplyCreditMemo;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public ApplyCreditMemoParams(String creditMemoId, ApplyUnapplyCreditMemo applyUnapplyCreditMemo) {
            this.creditMemoId = creditMemoId;
            this.applyUnapplyCreditMemo = applyUnapplyCreditMemo;
        }

        public ApplyCreditMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public ApplyCreditMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public ApplyCreditMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public ApplyCreditMemoParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public ApplyCreditMemoParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public ApplyCreditMemoParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public ApplyCreditMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public ApplyCreditMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public ApplyCreditMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public ApplyCreditMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public ApplyCreditMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public ApplyCreditMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

