/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.Mandate;

@ApiModel(description="If the `type` of the payment method is `apple_pay`, this hash contains details about the Apple Pay payment method. See [Supported payment methods](https://knowledgecenter.zuora.com/Billing/Billing_and_Payments/L_Payment_Methods/A_Supported_Payment_Methods) for payment gateways that support this type of payment method.")
public class ApplePayCreate {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CUSTOMER_TOKEN = "customer_token";
    @SerializedName(value="customer_token")
    private Map<String, Object> customerToken = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_COLLECT_PAYMENT = "collect_payment";
    @SerializedName(value="collect_payment")
    private Boolean collectPayment;
    public static final String SERIALIZED_NAME_INVOICE_ID = "invoice_id";
    @SerializedName(value="invoice_id")
    private String invoiceId;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;

    public ApplePayCreate id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Merchant ID that was configured for use with Apple Pay in the Apple iOS Developer Center.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ApplePayCreate customerToken(Map<String, Object> customerToken) {
        this.customerToken = customerToken;
        return this;
    }

    public ApplePayCreate putCustomerTokenItem(String key, Object customerTokenItem) {
        this.customerToken.put(key, customerTokenItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The complete JSON Object representing the encrypted payment token payload returned in the response from the Apple Pay session.")
    public Map<String, Object> getCustomerToken() {
        return this.customerToken;
    }

    public void setCustomerToken(Map<String, Object> customerToken) {
        this.customerToken = customerToken;
    }

    public ApplePayCreate collectPayment(Boolean collectPayment) {
        this.collectPayment = collectPayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean flag to control whether a payment should be processed       after creating payment method. The payment amount will be equivalent to       the amount the merchant supplied in the ApplePay session. Default is false.        If this field is set to `true`, you must specify the `gateway_id`       field with the payment gateway instance name.  If this field is set       to `false`:   - The default payment gateway of your Zuora customer account       will be used no matter whether a payment gateway instance is specified       in the `gateway_id` field.    - You must select the **Verify new       credit card** check box on the gateway instance settings page. Otherwise,       the cryptogram will not be sent to the gateway.   - A separate subscribe       or payment API call is required after this payment method creation call. ")
    public Boolean getCollectPayment() {
        return this.collectPayment;
    }

    public void setCollectPayment(Boolean collectPayment) {
        this.collectPayment = collectPayment;
    }

    public ApplePayCreate invoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of invoice this payment will apply to.      Note: When `collect_payment` is true, this field is required.      Only one invoice can be paid; for scenarios where you want to pay for multiple invoices, set collect_payment to false and use [Create Payment](#operation/createPayment) API separately.")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public ApplePayCreate mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplePayCreate applePayCreate = (ApplePayCreate)o;
        return Objects.equals(this.id, applePayCreate.id) && Objects.equals(this.customerToken, applePayCreate.customerToken) && Objects.equals(this.collectPayment, applePayCreate.collectPayment) && Objects.equals(this.invoiceId, applePayCreate.invoiceId) && Objects.equals(this.mandate, applePayCreate.mandate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.customerToken, this.collectPayment, this.invoiceId, this.mandate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplePayCreate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    customerToken: ").append(this.toIndentedString(this.customerToken)).append("\n");
        sb.append("    collectPayment: ").append(this.toIndentedString(this.collectPayment)).append("\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

