/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.ListAllSettingsResponse;
import com.zuora.model.SettingsBatchRequest;
import com.zuora.model.SettingsBatchResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SettingsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SettingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SettingsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getListAllSettingsCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String accept, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/settings/listing";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/csv", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getListAllSettingsValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String accept, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getListAllSettingsCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, accept, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected ListAllSettingsResponse getListAllSettings(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String accept, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<ListAllSettingsResponse> localVarResp = this.getListAllSettingsWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, accept, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<ListAllSettingsResponse> getListAllSettingsWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String accept, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getListAllSettingsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, accept, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ListAllSettingsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getListAllSettingsAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String accept, String zuoraVersion, String zuoraOrgIds, ApiCallback<ListAllSettingsResponse> _callback) throws ApiException {
        Call localVarCall = this.getListAllSettingsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, accept, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ListAllSettingsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetListAllSettingsApi getListAllSettingsApi() {
        return new GetListAllSettingsApi();
    }

    private Call postProcessSettingsBatchRequestCall(SettingsBatchRequest batchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SettingsBatchRequest localVarPostBody = batchRequest;
        String localVarPath = "/settings/batch-requests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postProcessSettingsBatchRequestValidateBeforeCall(SettingsBatchRequest batchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (batchRequest == null) {
            throw new ApiException("Missing the required parameter 'batchRequest' when calling postProcessSettingsBatchRequest(Async)");
        }
        return this.postProcessSettingsBatchRequestCall(batchRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected SettingsBatchResponse postProcessSettingsBatchRequest(SettingsBatchRequest batchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<SettingsBatchResponse> localVarResp = this.postProcessSettingsBatchRequestWithHttpInfo(batchRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<SettingsBatchResponse> postProcessSettingsBatchRequestWithHttpInfo(SettingsBatchRequest batchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postProcessSettingsBatchRequestValidateBeforeCall(batchRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SettingsBatchResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call postProcessSettingsBatchRequestAsync(SettingsBatchRequest batchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback<SettingsBatchResponse> _callback) throws ApiException {
        Call localVarCall = this.postProcessSettingsBatchRequestValidateBeforeCall(batchRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SettingsBatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostProcessSettingsBatchRequestApi postProcessSettingsBatchRequestApi(SettingsBatchRequest batchRequest) {
        return new PostProcessSettingsBatchRequestApi(batchRequest);
    }

    public class PostProcessSettingsBatchRequestApi {
        private final SettingsBatchRequest batchRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PostProcessSettingsBatchRequestApi(SettingsBatchRequest batchRequest) {
            this.batchRequest = batchRequest;
        }

        public PostProcessSettingsBatchRequestApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostProcessSettingsBatchRequestApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostProcessSettingsBatchRequestApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostProcessSettingsBatchRequestApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostProcessSettingsBatchRequestApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostProcessSettingsBatchRequestApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostProcessSettingsBatchRequestApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostProcessSettingsBatchRequestApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SettingsApi.this.postProcessSettingsBatchRequestCall(this.batchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public SettingsBatchResponse execute() throws ApiException {
            ApiResponse localVarResp = SettingsApi.this.postProcessSettingsBatchRequestWithHttpInfo(this.batchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
            return (SettingsBatchResponse)localVarResp.getData();
        }

        public ApiResponse<SettingsBatchResponse> executeWithHttpInfo() throws ApiException {
            return SettingsApi.this.postProcessSettingsBatchRequestWithHttpInfo(this.batchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<SettingsBatchResponse> _callback) throws ApiException {
            return SettingsApi.this.postProcessSettingsBatchRequestAsync(this.batchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetListAllSettingsApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String accept;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetListAllSettingsApi() {
        }

        public GetListAllSettingsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetListAllSettingsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetListAllSettingsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetListAllSettingsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetListAllSettingsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetListAllSettingsApi accept(String accept) {
            this.accept = accept;
            return this;
        }

        public GetListAllSettingsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetListAllSettingsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SettingsApi.this.getListAllSettingsCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.accept, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public ListAllSettingsResponse execute() throws ApiException {
            ApiResponse localVarResp = SettingsApi.this.getListAllSettingsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.accept, this.zuoraVersion, this.zuoraOrgIds);
            return (ListAllSettingsResponse)localVarResp.getData();
        }

        public ApiResponse<ListAllSettingsResponse> executeWithHttpInfo() throws ApiException {
            return SettingsApi.this.getListAllSettingsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.accept, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<ListAllSettingsResponse> _callback) throws ApiException {
            return SettingsApi.this.getListAllSettingsAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.accept, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

