/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import com.zuora.model.DocumentIdList;
import com.zuora.model.IndexFileFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BulkPdfGenerationJobRequest {
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private List<DocumentIdList> documents;
    public static final String SERIALIZED_NAME_FILE_NAME = "fileName";
    @SerializedName(value="fileName")
    private String fileName;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_INDEX_FILE_FORMAT = "indexFileFormat";
    @SerializedName(value="indexFileFormat")
    private IndexFileFormat indexFileFormat;
    public static final String SERIALIZED_NAME_GENERATE_MISSING_P_D_F = "generateMissingPDF";
    @SerializedName(value="generateMissingPDF")
    private Boolean generateMissingPDF;
    public static final String SERIALIZED_NAME_PERSIST_INDEX_FILE = "persistIndexFile";
    @SerializedName(value="persistIndexFile")
    private Boolean persistIndexFile;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BulkPdfGenerationJobRequest documents(List<DocumentIdList> documents) {
        this.documents = documents;
        return this;
    }

    public BulkPdfGenerationJobRequest addDocumentsItem(DocumentIdList documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<DocumentIdList>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nonnull
    public List<DocumentIdList> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<DocumentIdList> documents) {
        this.documents = documents;
    }

    public BulkPdfGenerationJobRequest fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Nonnull
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public BulkPdfGenerationJobRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BulkPdfGenerationJobRequest indexFileFormat(IndexFileFormat indexFileFormat) {
        this.indexFileFormat = indexFileFormat;
        return this;
    }

    @Nonnull
    public IndexFileFormat getIndexFileFormat() {
        return this.indexFileFormat;
    }

    public void setIndexFileFormat(IndexFileFormat indexFileFormat) {
        this.indexFileFormat = indexFileFormat;
    }

    public BulkPdfGenerationJobRequest generateMissingPDF(Boolean generateMissingPDF) {
        this.generateMissingPDF = generateMissingPDF;
        return this;
    }

    @Nullable
    public Boolean getGenerateMissingPDF() {
        return this.generateMissingPDF;
    }

    public void setGenerateMissingPDF(Boolean generateMissingPDF) {
        this.generateMissingPDF = generateMissingPDF;
    }

    public BulkPdfGenerationJobRequest persistIndexFile(Boolean persistIndexFile) {
        this.persistIndexFile = persistIndexFile;
        return this;
    }

    @Nullable
    public Boolean getPersistIndexFile() {
        return this.persistIndexFile;
    }

    public void setPersistIndexFile(Boolean persistIndexFile) {
        this.persistIndexFile = persistIndexFile;
    }

    public BulkPdfGenerationJobRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkPdfGenerationJobRequest bulkPdfGenerationJobRequest = (BulkPdfGenerationJobRequest)o;
        return Objects.equals(this.documents, bulkPdfGenerationJobRequest.documents) && Objects.equals(this.fileName, bulkPdfGenerationJobRequest.fileName) && Objects.equals(this.name, bulkPdfGenerationJobRequest.name) && Objects.equals((Object)this.indexFileFormat, (Object)bulkPdfGenerationJobRequest.indexFileFormat) && Objects.equals(this.generateMissingPDF, bulkPdfGenerationJobRequest.generateMissingPDF) && Objects.equals(this.persistIndexFile, bulkPdfGenerationJobRequest.persistIndexFile) && Objects.equals(this.additionalProperties, bulkPdfGenerationJobRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documents, this.fileName, this.name, this.indexFileFormat, this.generateMissingPDF, this.persistIndexFile, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkPdfGenerationJobRequest {\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    indexFileFormat: ").append(this.toIndentedString((Object)this.indexFileFormat)).append("\n");
        sb.append("    generateMissingPDF: ").append(this.toIndentedString(this.generateMissingPDF)).append("\n");
        sb.append("    persistIndexFile: ").append(this.toIndentedString(this.persistIndexFile)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in BulkPdfGenerationJobRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENTS).toString()));
        }
        JsonArray jsonArraydocuments = jsonObj.getAsJsonArray(SERIALIZED_NAME_DOCUMENTS);
        for (int i = 0; i < jsonArraydocuments.size(); ++i) {
            DocumentIdList.validateJsonElement(jsonArraydocuments.get(i));
        }
        if (!jsonObj.get(SERIALIZED_NAME_FILE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fileName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        IndexFileFormat.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INDEX_FILE_FORMAT));
    }

    public static BulkPdfGenerationJobRequest fromJson(String jsonString) throws IOException {
        return (BulkPdfGenerationJobRequest)JSON.getGson().fromJson(jsonString, BulkPdfGenerationJobRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DOCUMENTS);
        openapiFields.add(SERIALIZED_NAME_FILE_NAME);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_INDEX_FILE_FORMAT);
        openapiFields.add(SERIALIZED_NAME_GENERATE_MISSING_P_D_F);
        openapiFields.add(SERIALIZED_NAME_PERSIST_INDEX_FILE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DOCUMENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_FILE_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_INDEX_FILE_FORMAT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!BulkPdfGenerationJobRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BulkPdfGenerationJobRequest.class));
            return new TypeAdapter<BulkPdfGenerationJobRequest>(){

                public void write(JsonWriter out, BulkPdfGenerationJobRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, (Object)((JsonElement)e.getValue()));
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                                if (jsonElement.isJsonArray()) {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                } else {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                                }
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public BulkPdfGenerationJobRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    BulkPdfGenerationJobRequest.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    BulkPdfGenerationJobRequest instance = (BulkPdfGenerationJobRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

