/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class PaymentMethodAuthorizationResponse {
    public static final String SERIALIZED_NAME_AUTH_TRANSACTION_ID = "auth_transaction_id";
    @SerializedName(value="auth_transaction_id")
    private String authTransactionId;
    public static final String SERIALIZED_NAME_GATEWAY_ORDER_ID = "gateway_order_id";
    @SerializedName(value="gateway_order_id")
    private String gatewayOrderId;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;

    public PaymentMethodAuthorizationResponse authTransactionId(String authTransactionId) {
        this.authTransactionId = authTransactionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the authorization transaction from the payment gateway.")
    public String getAuthTransactionId() {
        return this.authTransactionId;
    }

    public void setAuthTransactionId(String authTransactionId) {
        this.authTransactionId = authTransactionId;
    }

    public PaymentMethodAuthorizationResponse gatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A merchant-specified natural key value that can be passed to the electronic payment gateway when a payment is created. If not specified, the payment number will be passed in instead. Gateways check duplicates on the gateway order ID to ensure that the merchant do not accidentally enter the same transaction twice. This ID can also be used to do reconciliation and tie the payment to a natural key in external systems. The source of this ID varies by merchant. Some merchants use their shopping cart order IDs, and others use something different. Merchants use this ID to track transactions in their eCommerce systems. When you create a payment for capturing the authorized funds, it is highly recommended to pass in the `gateway_order_id` that you used when authorizing the funds by using the Create authorization operation, together with the `authorization_id` field.")
    public String getGatewayOrderId() {
        return this.gatewayOrderId;
    }

    public void setGatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
    }

    public PaymentMethodAuthorizationResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the payment authorization.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodAuthorizationResponse paymentMethodAuthorizationResponse = (PaymentMethodAuthorizationResponse)o;
        return Objects.equals(this.authTransactionId, paymentMethodAuthorizationResponse.authTransactionId) && Objects.equals(this.gatewayOrderId, paymentMethodAuthorizationResponse.gatewayOrderId) && Objects.equals((Object)this.state, (Object)paymentMethodAuthorizationResponse.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authTransactionId, this.gatewayOrderId, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodAuthorizationResponse {\n");
        sb.append("    authTransactionId: ").append(this.toIndentedString(this.authTransactionId)).append("\n");
        sb.append("    gatewayOrderId: ").append(this.toIndentedString(this.gatewayOrderId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        APPROVED("approved"),
        QUEUED_FOR_SUBMISSION("queued_for_submission"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

