/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.SubscriptionPlan;
import org.openapitools.client.model.SubscriptionPlanListResponse;

public class SubscriptionPlansApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SubscriptionPlansApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionPlansApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getSubscriptionPlanCall(String subscriptionPlanId, List<String> fields, List<String> subscriptionPlanFields, List<String> subscriptionFields, List<String> subscriptionItemsFields, List<String> planFields, List<String> productFields, List<String> accountFields, List<String> priceFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscription_plans/{subscription_plan_id}".replace("{subscription_plan_id}", this.localVarApiClient.escapeString(subscriptionPlanId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionPlanFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plan.fields[]", subscriptionPlanFields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionPlanValidateBeforeCall(String subscriptionPlanId, List<String> fields, List<String> subscriptionPlanFields, List<String> subscriptionFields, List<String> subscriptionItemsFields, List<String> planFields, List<String> productFields, List<String> accountFields, List<String> priceFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionPlanId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionPlanId' when calling getSubscriptionPlan(Async)");
        }
        return this.getSubscriptionPlanCall(subscriptionPlanId, fields, subscriptionPlanFields, subscriptionFields, subscriptionItemsFields, planFields, productFields, accountFields, priceFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<SubscriptionPlan> getSubscriptionPlanWithHttpInfo(String subscriptionPlanId, List<String> fields, List<String> subscriptionPlanFields, List<String> subscriptionFields, List<String> subscriptionItemsFields, List<String> planFields, List<String> productFields, List<String> accountFields, List<String> priceFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionPlanValidateBeforeCall(subscriptionPlanId, fields, subscriptionPlanFields, subscriptionFields, subscriptionItemsFields, planFields, productFields, accountFields, priceFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SubscriptionPlan>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getSubscriptionPlanAsync(String subscriptionPlanId, List<String> fields, List<String> subscriptionPlanFields, List<String> subscriptionFields, List<String> subscriptionItemsFields, List<String> planFields, List<String> productFields, List<String> accountFields, List<String> priceFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<SubscriptionPlan> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionPlanValidateBeforeCall(subscriptionPlanId, fields, subscriptionPlanFields, subscriptionFields, subscriptionItemsFields, planFields, productFields, accountFields, priceFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionPlan>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionPlanParams getSubscriptionPlanParams(String subscriptionPlanId) {
        return new GetSubscriptionPlanParams(subscriptionPlanId);
    }

    public SubscriptionPlan getSubscriptionPlan(String subscriptionPlanId) throws ApiException {
        GetSubscriptionPlanParams params = new GetSubscriptionPlanParams(subscriptionPlanId);
        return this.executeGetSubscriptionPlanAPICall(params).getData();
    }

    public SubscriptionPlan getSubscriptionPlan(String subscriptionPlanId, List<String> expand) throws ApiException {
        GetSubscriptionPlanParams params = new GetSubscriptionPlanParams(subscriptionPlanId);
        params.expand(expand);
        return this.executeGetSubscriptionPlanAPICall(params).getData();
    }

    public SubscriptionPlan getSubscriptionPlan(String subscriptionPlanId, List<String> expand, Headers headers) throws ApiException {
        GetSubscriptionPlanParams params = new GetSubscriptionPlanParams(subscriptionPlanId).expand(expand).headers(headers);
        return this.executeGetSubscriptionPlanAPICall(params).getData();
    }

    public SubscriptionPlan get(GetSubscriptionPlanParams params) throws ApiException {
        return this.executeGetSubscriptionPlanAPICall(params).getData();
    }

    public ApiResponse<SubscriptionPlan> getWithHttpInfo(GetSubscriptionPlanParams params) throws ApiException {
        return this.executeGetSubscriptionPlanAPICall(params);
    }

    ApiResponse<SubscriptionPlan> executeGetSubscriptionPlanAPICall(GetSubscriptionPlanParams params) throws ApiException {
        return this.getSubscriptionPlanWithHttpInfo(params.subscriptionPlanId, params.fields, params.subscriptionPlanFields, params.subscriptionFields, params.subscriptionItemsFields, params.planFields, params.productFields, params.accountFields, params.priceFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getSubscriptionPlansCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionPlanFields, List<String> subscriptionFields, List<String> subscriptionItemsFields, List<String> planFields, List<String> productFields, List<String> accountFields, List<String> priceFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscription_plans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionPlanFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plan.fields[]", subscriptionPlanFields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionPlansValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionPlanFields, List<String> subscriptionFields, List<String> subscriptionItemsFields, List<String> planFields, List<String> productFields, List<String> accountFields, List<String> priceFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getSubscriptionPlansCall(cursor, expand, filter, sort, pageSize, fields, subscriptionPlanFields, subscriptionFields, subscriptionItemsFields, planFields, productFields, accountFields, priceFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<SubscriptionPlanListResponse> getSubscriptionPlansWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionPlanFields, List<String> subscriptionFields, List<String> subscriptionItemsFields, List<String> planFields, List<String> productFields, List<String> accountFields, List<String> priceFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionPlansValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, subscriptionPlanFields, subscriptionFields, subscriptionItemsFields, planFields, productFields, accountFields, priceFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SubscriptionPlanListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getSubscriptionPlansAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionPlanFields, List<String> subscriptionFields, List<String> subscriptionItemsFields, List<String> planFields, List<String> productFields, List<String> accountFields, List<String> priceFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<SubscriptionPlanListResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionPlansValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, subscriptionPlanFields, subscriptionFields, subscriptionItemsFields, planFields, productFields, accountFields, priceFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionPlanListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionPlansParams getSubscriptionPlansParams() {
        return new GetSubscriptionPlansParams();
    }

    public SubscriptionPlanListResponse getSubscriptionPlans() throws ApiException {
        GetSubscriptionPlansParams params = new GetSubscriptionPlansParams();
        return this.executeGetSubscriptionPlansAPICall(params).getData();
    }

    public SubscriptionPlanListResponse getSubscriptionPlans(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetSubscriptionPlansParams params = new GetSubscriptionPlansParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetSubscriptionPlansAPICall(params).getData();
    }

    public SubscriptionPlanListResponse getSubscriptionPlans(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetSubscriptionPlansParams params = new GetSubscriptionPlansParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetSubscriptionPlansAPICall(params).getData();
    }

    public SubscriptionPlanListResponse list(GetSubscriptionPlansParams params) throws ApiException {
        return this.executeGetSubscriptionPlansAPICall(params).getData();
    }

    public ApiResponse<SubscriptionPlanListResponse> listWithHttpInfo(GetSubscriptionPlansParams params) throws ApiException {
        return this.executeGetSubscriptionPlansAPICall(params);
    }

    ApiResponse<SubscriptionPlanListResponse> executeGetSubscriptionPlansAPICall(GetSubscriptionPlansParams params) throws ApiException {
        return this.getSubscriptionPlansWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.subscriptionPlanFields, params.subscriptionFields, params.subscriptionItemsFields, params.planFields, params.productFields, params.accountFields, params.priceFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    public static class GetSubscriptionPlansParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> subscriptionPlanFields;
        private List<String> subscriptionFields;
        private List<String> subscriptionItemsFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> accountFields;
        private List<String> priceFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetSubscriptionPlansParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetSubscriptionPlansParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetSubscriptionPlansParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetSubscriptionPlansParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetSubscriptionPlansParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetSubscriptionPlansParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetSubscriptionPlansParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetSubscriptionPlansParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetSubscriptionPlansParams subscriptionPlanFields(List<String> subscriptionPlanFields) {
            this.subscriptionPlanFields = subscriptionPlanFields;
            return this;
        }

        public GetSubscriptionPlansParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public GetSubscriptionPlansParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetSubscriptionPlansParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public GetSubscriptionPlansParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public GetSubscriptionPlansParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetSubscriptionPlansParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }
    }

    public static class GetSubscriptionPlanParams {
        private final String subscriptionPlanId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionPlanFields;
        private List<String> subscriptionFields;
        private List<String> subscriptionItemsFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> accountFields;
        private List<String> priceFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetSubscriptionPlanParams(String subscriptionPlanId) {
            this.subscriptionPlanId = subscriptionPlanId;
        }

        public GetSubscriptionPlanParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetSubscriptionPlanParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetSubscriptionPlanParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetSubscriptionPlanParams subscriptionPlanFields(List<String> subscriptionPlanFields) {
            this.subscriptionPlanFields = subscriptionPlanFields;
            return this;
        }

        public GetSubscriptionPlanParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public GetSubscriptionPlanParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetSubscriptionPlanParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public GetSubscriptionPlanParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public GetSubscriptionPlanParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetSubscriptionPlanParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public GetSubscriptionPlanParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetSubscriptionPlanParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetSubscriptionPlanParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

