/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum BillingDocumentItemSourceType {
    SUBSCRIPTIONCOMPONENT("SubscriptionComponent"),
    PRODUCTRATEPLANCHARGE("ProductRatePlanCharge"),
    ORDERLINEITEM("OrderLineItem"),
    INVOICEDETAIL("InvoiceDetail"),
    CREDITMEMOITEM("CreditMemoItem"),
    DEBITMEMOITEM("DebitMemoItem"),
    ADJUSTMENT("Adjustment"),
    ROUNDING("Rounding"),
    NONE("None"),
    SURCHARGE("Surcharge"),
    COMMITMENT("Commitment");

    private String value;

    private BillingDocumentItemSourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingDocumentItemSourceType fromValue(String value) {
        for (BillingDocumentItemSourceType b : BillingDocumentItemSourceType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        BillingDocumentItemSourceType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<BillingDocumentItemSourceType> {
        public void write(JsonWriter jsonWriter, BillingDocumentItemSourceType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public BillingDocumentItemSourceType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return BillingDocumentItemSourceType.fromValue(value);
        }
    }
}

