/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.RefundCreditMemoItemRequest;

public class RefundCreditMemoRequest {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_CREDIT_MEMO_ITEMS = "credit_memo_items";
    @SerializedName(value="credit_memo_items")
    private List<RefundCreditMemoItemRequest> creditMemoItems = null;
    public static final String SERIALIZED_NAME_TAXATION_ITEMS = "taxation_items";
    @SerializedName(value="taxation_items")
    private List<RefundCreditMemoItemRequest> taxationItems = null;

    public RefundCreditMemoRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the credit memo taxation item")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RefundCreditMemoRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Refund amount.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public RefundCreditMemoRequest creditMemoItems(List<RefundCreditMemoItemRequest> creditMemoItems) {
        this.creditMemoItems = creditMemoItems;
        return this;
    }

    public RefundCreditMemoRequest addCreditMemoItemsItem(RefundCreditMemoItemRequest creditMemoItemsItem) {
        if (this.creditMemoItems == null) {
            this.creditMemoItems = new ArrayList<RefundCreditMemoItemRequest>();
        }
        this.creditMemoItems.add(creditMemoItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The items to which the credit memo is applied.")
    public List<RefundCreditMemoItemRequest> getCreditMemoItems() {
        return this.creditMemoItems;
    }

    public void setCreditMemoItems(List<RefundCreditMemoItemRequest> creditMemoItems) {
        this.creditMemoItems = creditMemoItems;
    }

    public RefundCreditMemoRequest taxationItems(List<RefundCreditMemoItemRequest> taxationItems) {
        this.taxationItems = taxationItems;
        return this;
    }

    public RefundCreditMemoRequest addTaxationItemsItem(RefundCreditMemoItemRequest taxationItemsItem) {
        if (this.taxationItems == null) {
            this.taxationItems = new ArrayList<RefundCreditMemoItemRequest>();
        }
        this.taxationItems.add(taxationItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The items to which the credit memo is applied.")
    public List<RefundCreditMemoItemRequest> getTaxationItems() {
        return this.taxationItems;
    }

    public void setTaxationItems(List<RefundCreditMemoItemRequest> taxationItems) {
        this.taxationItems = taxationItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundCreditMemoRequest refundCreditMemoRequest = (RefundCreditMemoRequest)o;
        return Objects.equals(this.id, refundCreditMemoRequest.id) && Objects.equals(this.amount, refundCreditMemoRequest.amount) && Objects.equals(this.creditMemoItems, refundCreditMemoRequest.creditMemoItems) && Objects.equals(this.taxationItems, refundCreditMemoRequest.taxationItems);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.amount, this.creditMemoItems, this.taxationItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundCreditMemoRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    creditMemoItems: ").append(this.toIndentedString(this.creditMemoItems)).append("\n");
        sb.append("    taxationItems: ").append(this.toIndentedString(this.taxationItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

