/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.threeten.bp.LocalDate;

public class InvoicePatchRequest {
    public static final String SERIALIZED_NAME_PAY = "pay";
    @SerializedName(value="pay")
    private Boolean pay;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DUE_DATE = "due_date";
    @SerializedName(value="due_date")
    private LocalDate dueDate;
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;

    public InvoicePatchRequest pay(Boolean pay) {
        this.pay = pay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the billing document is automatically picked up for processing in the corresponding payment run.")
    public Boolean getPay() {
        return this.pay;
    }

    public void setPay(Boolean pay) {
        this.pay = pay;
    }

    public InvoicePatchRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InvoicePatchRequest dueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date on which payment for the billing document is due.")
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public InvoicePatchRequest documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the billing document takes effect.")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public InvoicePatchRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public InvoicePatchRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoicePatchRequest invoicePatchRequest = (InvoicePatchRequest)o;
        return Objects.equals(this.pay, invoicePatchRequest.pay) && Objects.equals(this.description, invoicePatchRequest.description) && Objects.equals(this.dueDate, invoicePatchRequest.dueDate) && Objects.equals(this.documentDate, invoicePatchRequest.documentDate) && Objects.equals(this.customFields, invoicePatchRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(this.pay, this.description, this.dueDate, this.documentDate, this.customFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoicePatchRequest {\n");
        sb.append("    pay: ").append(this.toIndentedString(this.pay)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

