/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The prepayment information.")
public class SubscriptionItemPrepaymentField {
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_VALIDITY_PERIOD = "validity_period";
    @SerializedName(value="validity_period")
    private ValidityPeriodEnum validityPeriod;

    public SubscriptionItemPrepaymentField quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of units included in a prepayment charge.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public SubscriptionItemPrepaymentField validityPeriod(ValidityPeriodEnum validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The period in which the prepayment units are valid to use as defined in a prepayment charge.")
    public ValidityPeriodEnum getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(ValidityPeriodEnum validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionItemPrepaymentField subscriptionItemPrepaymentField = (SubscriptionItemPrepaymentField)o;
        return Objects.equals(this.quantity, subscriptionItemPrepaymentField.quantity) && Objects.equals((Object)this.validityPeriod, (Object)subscriptionItemPrepaymentField.validityPeriod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quantity, this.validityPeriod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionItemPrepaymentField {\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    validityPeriod: ").append(this.toIndentedString((Object)this.validityPeriod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ValidityPeriodEnum {
        SUBSCRIPTION_TERM("subscription_term"),
        ANNUAL("annual"),
        SEMI_ANNUAL("semi_annual"),
        QUARTER("quarter"),
        MONTH("month"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ValidityPeriodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ValidityPeriodEnum fromValue(String value) {
            for (ValidityPeriodEnum b : ValidityPeriodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ValidityPeriodEnum> {
            public void write(JsonWriter jsonWriter, ValidityPeriodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ValidityPeriodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ValidityPeriodEnum.fromValue(value);
            }
        }
    }
}

