/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.AccountCreateRequest;
import org.openapitools.client.model.CancelSubscriptionRequest;
import org.openapitools.client.model.FlexibleBillingDocumentSettings;
import org.openapitools.client.model.PauseSubscriptionRequest;
import org.openapitools.client.model.ProcessingOptions;
import org.openapitools.client.model.ResumeSubscriptionRequest;
import org.openapitools.client.model.StartOn;
import org.openapitools.client.model.SubscriptionAddPlanPatchRequest;
import org.openapitools.client.model.SubscriptionPlanCreateRequest;
import org.openapitools.client.model.SubscriptionRemovePlanPatchRequest;
import org.openapitools.client.model.SubscriptionRenewPatchRequest;
import org.openapitools.client.model.SubscriptionReplacePlanPatchRequest;
import org.openapitools.client.model.SubscriptionTermPatchRequest;
import org.openapitools.client.model.SubscriptionUpdatePlanPatchRequest;
import org.openapitools.client.model.Term;
import org.openapitools.jackson.nullable.JsonNullable;

public class PostSubscriptionOrderRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_DATA = "account_data";
    @SerializedName(value="account_data")
    private AccountCreateRequest accountData;
    public static final String SERIALIZED_NAME_INVOICE_OWNER_ACCOUNT_NUMBER = "invoice_owner_account_number";
    @SerializedName(value="invoice_owner_account_number")
    private String invoiceOwnerAccountNumber;
    public static final String SERIALIZED_NAME_AUTO_RENEW = "auto_renew";
    @SerializedName(value="auto_renew")
    private Boolean autoRenew;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_NUMBER = "subscription_number";
    @SerializedName(value="subscription_number")
    private String subscriptionNumber;
    public static final String SERIALIZED_NAME_INITIAL_TERM = "initial_term";
    @SerializedName(value="initial_term")
    private Term initialTerm;
    public static final String SERIALIZED_NAME_RENEWAL_TERM = "renewal_term";
    @SerializedName(value="renewal_term")
    private Term renewalTerm;
    public static final String SERIALIZED_NAME_START_ON = "start_on";
    @SerializedName(value="start_on")
    private StartOn startOn;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_INVOICE_SEPARATELY = "invoice_separately";
    @SerializedName(value="invoice_separately")
    private Boolean invoiceSeparately;
    public static final String SERIALIZED_NAME_PROCESSING_OPTIONS = "processing_options";
    @SerializedName(value="processing_options")
    private ProcessingOptions processingOptions;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLANS = "subscription_plans";
    @SerializedName(value="subscription_plans")
    private List<SubscriptionPlanCreateRequest> subscriptionPlans = null;
    public static final String SERIALIZED_NAME_ADD_SUBSCRIPTION_PLANS = "add_subscription_plans";
    @SerializedName(value="add_subscription_plans")
    private List<SubscriptionAddPlanPatchRequest> addSubscriptionPlans = null;
    public static final String SERIALIZED_NAME_REMOVE_SUBSCRIPTION_PLANS = "remove_subscription_plans";
    @SerializedName(value="remove_subscription_plans")
    private List<SubscriptionRemovePlanPatchRequest> removeSubscriptionPlans = null;
    public static final String SERIALIZED_NAME_UPDATE_SUBSCRIPTION_PLANS = "update_subscription_plans";
    @SerializedName(value="update_subscription_plans")
    private List<SubscriptionUpdatePlanPatchRequest> updateSubscriptionPlans = null;
    public static final String SERIALIZED_NAME_RENEW = "renew";
    @SerializedName(value="renew")
    private SubscriptionRenewPatchRequest renew;
    public static final String SERIALIZED_NAME_RENEWALS = "renewals";
    @SerializedName(value="renewals")
    private List<SubscriptionRenewPatchRequest> renewals = null;
    public static final String SERIALIZED_NAME_CANCEL = "cancel";
    @SerializedName(value="cancel")
    private CancelSubscriptionRequest cancel;
    public static final String SERIALIZED_NAME_PAUSE = "pause";
    @SerializedName(value="pause")
    private PauseSubscriptionRequest pause;
    public static final String SERIALIZED_NAME_RESUME = "resume";
    @SerializedName(value="resume")
    private ResumeSubscriptionRequest resume;
    public static final String SERIALIZED_NAME_REPLACE_SUBSCRIPTION_PLANS = "replace_subscription_plans";
    @SerializedName(value="replace_subscription_plans")
    private List<SubscriptionReplacePlanPatchRequest> replaceSubscriptionPlans = null;
    public static final String SERIALIZED_NAME_TERMS = "terms";
    @SerializedName(value="terms")
    private SubscriptionTermPatchRequest terms;
    public static final String SERIALIZED_NAME_BILL_TO_ID = "bill_to_id";
    @SerializedName(value="bill_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String billToId;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String soldToId;
    public static final String SERIALIZED_NAME_PAYMENT_TERMS = "payment_terms";
    @SerializedName(value="payment_terms")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String paymentTerms;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_SETTINGS = "billing_document_settings";
    @SerializedName(value="billing_document_settings")
    private FlexibleBillingDocumentSettings billingDocumentSettings;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_CHANGE_REASON = "change_reason";
    @SerializedName(value="change_reason")
    private String changeReason;

    public PostSubscriptionOrderRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the subscription. Subscription owner account can be different from the invoice owner account. If you specify this field, do not specify `account_data`.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PostSubscriptionOrderRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the subscription. Subscription owner account can be different from the invoice owner account. If you specify this field, do not specify `account_data`.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PostSubscriptionOrderRequest accountData(AccountCreateRequest accountData) {
        this.accountData = accountData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The information of the new account that owns the subscription. The subscription owner account can be different from the invoice owner account. If you specify this field, do not specify `account_id`.")
    public AccountCreateRequest getAccountData() {
        return this.accountData;
    }

    public void setAccountData(AccountCreateRequest accountData) {
        this.accountData = accountData;
    }

    public PostSubscriptionOrderRequest invoiceOwnerAccountNumber(String invoiceOwnerAccountNumber) {
        this.invoiceOwnerAccountNumber = invoiceOwnerAccountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the invoice associated with this subscription. If you specify this field, do not specify `invoice_owner_account_data`.")
    public String getInvoiceOwnerAccountNumber() {
        return this.invoiceOwnerAccountNumber;
    }

    public void setInvoiceOwnerAccountNumber(String invoiceOwnerAccountNumber) {
        this.invoiceOwnerAccountNumber = invoiceOwnerAccountNumber;
    }

    public PostSubscriptionOrderRequest autoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, the subscription automatically renews at the end of the current term.")
    public Boolean getAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public PostSubscriptionOrderRequest subscriptionNumber(String subscriptionNumber) {
        this.subscriptionNumber = subscriptionNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the subscription. If an existing `subscription_number` is supplied, the order will update that subscription. Meanwhile, if the specified `subscription_number` does not exist in the tenant, it will instead create a new one")
    public String getSubscriptionNumber() {
        return this.subscriptionNumber;
    }

    public void setSubscriptionNumber(String subscriptionNumber) {
        this.subscriptionNumber = subscriptionNumber;
    }

    public PostSubscriptionOrderRequest initialTerm(Term initialTerm) {
        this.initialTerm = initialTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Initial term information for the subscription.")
    public Term getInitialTerm() {
        return this.initialTerm;
    }

    public void setInitialTerm(Term initialTerm) {
        this.initialTerm = initialTerm;
    }

    public PostSubscriptionOrderRequest renewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Renewal term information for the subscription")
    public Term getRenewalTerm() {
        return this.renewalTerm;
    }

    public void setRenewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
    }

    public PostSubscriptionOrderRequest startOn(StartOn startOn) {
        this.startOn = startOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StartOn getStartOn() {
        return this.startOn;
    }

    public void setStartOn(StartOn startOn) {
        this.startOn = startOn;
    }

    public PostSubscriptionOrderRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the subscription. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PostSubscriptionOrderRequest invoiceSeparately(Boolean invoiceSeparately) {
        this.invoiceSeparately = invoiceSeparately;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Separates a single subscription from other subscriptions and creates an invoice for this subscription. If the value is `true`, the subscription is billed separately from other subscriptions. If the value is `false`, the subscription is included with other subscriptions in the account invoice.")
    public Boolean getInvoiceSeparately() {
        return this.invoiceSeparately;
    }

    public void setInvoiceSeparately(Boolean invoiceSeparately) {
        this.invoiceSeparately = invoiceSeparately;
    }

    public PostSubscriptionOrderRequest processingOptions(ProcessingOptions processingOptions) {
        this.processingOptions = processingOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessingOptions getProcessingOptions() {
        return this.processingOptions;
    }

    public void setProcessingOptions(ProcessingOptions processingOptions) {
        this.processingOptions = processingOptions;
    }

    public PostSubscriptionOrderRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PostSubscriptionOrderRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public PostSubscriptionOrderRequest subscriptionPlans(List<SubscriptionPlanCreateRequest> subscriptionPlans) {
        this.subscriptionPlans = subscriptionPlans;
        return this;
    }

    public PostSubscriptionOrderRequest addSubscriptionPlansItem(SubscriptionPlanCreateRequest subscriptionPlansItem) {
        if (this.subscriptionPlans == null) {
            this.subscriptionPlans = new ArrayList<SubscriptionPlanCreateRequest>();
        }
        this.subscriptionPlans.add(subscriptionPlansItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The plans associated with the new subscription.")
    public List<SubscriptionPlanCreateRequest> getSubscriptionPlans() {
        return this.subscriptionPlans;
    }

    public void setSubscriptionPlans(List<SubscriptionPlanCreateRequest> subscriptionPlans) {
        this.subscriptionPlans = subscriptionPlans;
    }

    public PostSubscriptionOrderRequest addSubscriptionPlans(List<SubscriptionAddPlanPatchRequest> addSubscriptionPlans) {
        this.addSubscriptionPlans = addSubscriptionPlans;
        return this;
    }

    public PostSubscriptionOrderRequest addAddSubscriptionPlansItem(SubscriptionAddPlanPatchRequest addSubscriptionPlansItem) {
        if (this.addSubscriptionPlans == null) {
            this.addSubscriptionPlans = new ArrayList<SubscriptionAddPlanPatchRequest>();
        }
        this.addSubscriptionPlans.add(addSubscriptionPlansItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify this field if you want to add one or multiple subscription plans to this subscription.")
    public List<SubscriptionAddPlanPatchRequest> getAddSubscriptionPlans() {
        return this.addSubscriptionPlans;
    }

    public void setAddSubscriptionPlans(List<SubscriptionAddPlanPatchRequest> addSubscriptionPlans) {
        this.addSubscriptionPlans = addSubscriptionPlans;
    }

    public PostSubscriptionOrderRequest removeSubscriptionPlans(List<SubscriptionRemovePlanPatchRequest> removeSubscriptionPlans) {
        this.removeSubscriptionPlans = removeSubscriptionPlans;
        return this;
    }

    public PostSubscriptionOrderRequest addRemoveSubscriptionPlansItem(SubscriptionRemovePlanPatchRequest removeSubscriptionPlansItem) {
        if (this.removeSubscriptionPlans == null) {
            this.removeSubscriptionPlans = new ArrayList<SubscriptionRemovePlanPatchRequest>();
        }
        this.removeSubscriptionPlans.add(removeSubscriptionPlansItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify this field if you want to remove one or multiple subscription plans from this subscription.")
    public List<SubscriptionRemovePlanPatchRequest> getRemoveSubscriptionPlans() {
        return this.removeSubscriptionPlans;
    }

    public void setRemoveSubscriptionPlans(List<SubscriptionRemovePlanPatchRequest> removeSubscriptionPlans) {
        this.removeSubscriptionPlans = removeSubscriptionPlans;
    }

    public PostSubscriptionOrderRequest updateSubscriptionPlans(List<SubscriptionUpdatePlanPatchRequest> updateSubscriptionPlans) {
        this.updateSubscriptionPlans = updateSubscriptionPlans;
        return this;
    }

    public PostSubscriptionOrderRequest addUpdateSubscriptionPlansItem(SubscriptionUpdatePlanPatchRequest updateSubscriptionPlansItem) {
        if (this.updateSubscriptionPlans == null) {
            this.updateSubscriptionPlans = new ArrayList<SubscriptionUpdatePlanPatchRequest>();
        }
        this.updateSubscriptionPlans.add(updateSubscriptionPlansItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<SubscriptionUpdatePlanPatchRequest> getUpdateSubscriptionPlans() {
        return this.updateSubscriptionPlans;
    }

    public void setUpdateSubscriptionPlans(List<SubscriptionUpdatePlanPatchRequest> updateSubscriptionPlans) {
        this.updateSubscriptionPlans = updateSubscriptionPlans;
    }

    public PostSubscriptionOrderRequest renew(SubscriptionRenewPatchRequest renew) {
        this.renew = renew;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionRenewPatchRequest getRenew() {
        return this.renew;
    }

    public void setRenew(SubscriptionRenewPatchRequest renew) {
        this.renew = renew;
    }

    public PostSubscriptionOrderRequest renewals(List<SubscriptionRenewPatchRequest> renewals) {
        this.renewals = renewals;
        return this;
    }

    public PostSubscriptionOrderRequest addRenewalsItem(SubscriptionRenewPatchRequest renewalsItem) {
        if (this.renewals == null) {
            this.renewals = new ArrayList<SubscriptionRenewPatchRequest>();
        }
        this.renewals.add(renewalsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify this field when renewing a subscription.")
    public List<SubscriptionRenewPatchRequest> getRenewals() {
        return this.renewals;
    }

    public void setRenewals(List<SubscriptionRenewPatchRequest> renewals) {
        this.renewals = renewals;
    }

    public PostSubscriptionOrderRequest cancel(CancelSubscriptionRequest cancel) {
        this.cancel = cancel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CancelSubscriptionRequest getCancel() {
        return this.cancel;
    }

    public void setCancel(CancelSubscriptionRequest cancel) {
        this.cancel = cancel;
    }

    public PostSubscriptionOrderRequest pause(PauseSubscriptionRequest pause) {
        this.pause = pause;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PauseSubscriptionRequest getPause() {
        return this.pause;
    }

    public void setPause(PauseSubscriptionRequest pause) {
        this.pause = pause;
    }

    public PostSubscriptionOrderRequest resume(ResumeSubscriptionRequest resume) {
        this.resume = resume;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ResumeSubscriptionRequest getResume() {
        return this.resume;
    }

    public void setResume(ResumeSubscriptionRequest resume) {
        this.resume = resume;
    }

    public PostSubscriptionOrderRequest replaceSubscriptionPlans(List<SubscriptionReplacePlanPatchRequest> replaceSubscriptionPlans) {
        this.replaceSubscriptionPlans = replaceSubscriptionPlans;
        return this;
    }

    public PostSubscriptionOrderRequest addReplaceSubscriptionPlansItem(SubscriptionReplacePlanPatchRequest replaceSubscriptionPlansItem) {
        if (this.replaceSubscriptionPlans == null) {
            this.replaceSubscriptionPlans = new ArrayList<SubscriptionReplacePlanPatchRequest>();
        }
        this.replaceSubscriptionPlans.add(replaceSubscriptionPlansItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify this field if you want to replace one or multiple subscription plans to this subscription. <br />            **Note**: This field is currently not supported if you have Billing - Revenue Integration enabled. When Billing - Revenue Integration is enabled, the replace subscription plan type of order action will no longer be applicable in Zuora Billing. ")
    public List<SubscriptionReplacePlanPatchRequest> getReplaceSubscriptionPlans() {
        return this.replaceSubscriptionPlans;
    }

    public void setReplaceSubscriptionPlans(List<SubscriptionReplacePlanPatchRequest> replaceSubscriptionPlans) {
        this.replaceSubscriptionPlans = replaceSubscriptionPlans;
    }

    public PostSubscriptionOrderRequest terms(SubscriptionTermPatchRequest terms) {
        this.terms = terms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionTermPatchRequest getTerms() {
        return this.terms;
    }

    public void setTerms(SubscriptionTermPatchRequest terms) {
        this.terms = terms;
    }

    public PostSubscriptionOrderRequest billToId(String billToId) {
        this.billToId = billToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the bill-to contact.")
    public String getBillToId() {
        return this.billToId;
    }

    public void setBillToId(String billToId) {
        this.billToId = billToId;
    }

    public PostSubscriptionOrderRequest soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the sold-to contact.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    public PostSubscriptionOrderRequest paymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of payment term associated with the invoice.")
    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public PostSubscriptionOrderRequest billingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document settings for the customer.")
    public FlexibleBillingDocumentSettings getBillingDocumentSettings() {
        return this.billingDocumentSettings;
    }

    public void setBillingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
    }

    public PostSubscriptionOrderRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="3-letter ISO 4217 currency code. This field is available only if you have the [Multiple Currencies](https://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Flexible_Billing/Multiple_Currencies) feature enabled.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PostSubscriptionOrderRequest changeReason(String changeReason) {
        this.changeReason = changeReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief description of the reason for this change.")
    public String getChangeReason() {
        return this.changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostSubscriptionOrderRequest postSubscriptionOrderRequest = (PostSubscriptionOrderRequest)o;
        return Objects.equals(this.accountNumber, postSubscriptionOrderRequest.accountNumber) && Objects.equals(this.accountId, postSubscriptionOrderRequest.accountId) && Objects.equals(this.accountData, postSubscriptionOrderRequest.accountData) && Objects.equals(this.invoiceOwnerAccountNumber, postSubscriptionOrderRequest.invoiceOwnerAccountNumber) && Objects.equals(this.autoRenew, postSubscriptionOrderRequest.autoRenew) && Objects.equals(this.subscriptionNumber, postSubscriptionOrderRequest.subscriptionNumber) && Objects.equals(this.initialTerm, postSubscriptionOrderRequest.initialTerm) && Objects.equals(this.renewalTerm, postSubscriptionOrderRequest.renewalTerm) && Objects.equals(this.startOn, postSubscriptionOrderRequest.startOn) && Objects.equals(this.description, postSubscriptionOrderRequest.description) && Objects.equals(this.invoiceSeparately, postSubscriptionOrderRequest.invoiceSeparately) && Objects.equals(this.processingOptions, postSubscriptionOrderRequest.processingOptions) && Objects.equals(this.customFields, postSubscriptionOrderRequest.customFields) && Objects.equals(this.subscriptionPlans, postSubscriptionOrderRequest.subscriptionPlans) && Objects.equals(this.addSubscriptionPlans, postSubscriptionOrderRequest.addSubscriptionPlans) && Objects.equals(this.removeSubscriptionPlans, postSubscriptionOrderRequest.removeSubscriptionPlans) && Objects.equals(this.updateSubscriptionPlans, postSubscriptionOrderRequest.updateSubscriptionPlans) && Objects.equals(this.renew, postSubscriptionOrderRequest.renew) && Objects.equals(this.renewals, postSubscriptionOrderRequest.renewals) && Objects.equals(this.cancel, postSubscriptionOrderRequest.cancel) && Objects.equals(this.pause, postSubscriptionOrderRequest.pause) && Objects.equals(this.resume, postSubscriptionOrderRequest.resume) && Objects.equals(this.replaceSubscriptionPlans, postSubscriptionOrderRequest.replaceSubscriptionPlans) && Objects.equals(this.terms, postSubscriptionOrderRequest.terms) && Objects.equals(this.billToId, postSubscriptionOrderRequest.billToId) && Objects.equals(this.soldToId, postSubscriptionOrderRequest.soldToId) && Objects.equals(this.paymentTerms, postSubscriptionOrderRequest.paymentTerms) && Objects.equals(this.billingDocumentSettings, postSubscriptionOrderRequest.billingDocumentSettings) && Objects.equals(this.currency, postSubscriptionOrderRequest.currency) && Objects.equals(this.changeReason, postSubscriptionOrderRequest.changeReason);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.accountNumber, this.accountId, this.accountData, this.invoiceOwnerAccountNumber, this.autoRenew, this.subscriptionNumber, this.initialTerm, this.renewalTerm, this.startOn, this.description, this.invoiceSeparately, this.processingOptions, this.customFields, this.subscriptionPlans, this.addSubscriptionPlans, this.removeSubscriptionPlans, this.updateSubscriptionPlans, this.renew, this.renewals, this.cancel, this.pause, this.resume, this.replaceSubscriptionPlans, this.terms, this.billToId, this.soldToId, this.paymentTerms, this.billingDocumentSettings, this.currency, this.changeReason);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostSubscriptionOrderRequest {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountData: ").append(this.toIndentedString(this.accountData)).append("\n");
        sb.append("    invoiceOwnerAccountNumber: ").append(this.toIndentedString(this.invoiceOwnerAccountNumber)).append("\n");
        sb.append("    autoRenew: ").append(this.toIndentedString(this.autoRenew)).append("\n");
        sb.append("    subscriptionNumber: ").append(this.toIndentedString(this.subscriptionNumber)).append("\n");
        sb.append("    initialTerm: ").append(this.toIndentedString(this.initialTerm)).append("\n");
        sb.append("    renewalTerm: ").append(this.toIndentedString(this.renewalTerm)).append("\n");
        sb.append("    startOn: ").append(this.toIndentedString(this.startOn)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    invoiceSeparately: ").append(this.toIndentedString(this.invoiceSeparately)).append("\n");
        sb.append("    processingOptions: ").append(this.toIndentedString(this.processingOptions)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    subscriptionPlans: ").append(this.toIndentedString(this.subscriptionPlans)).append("\n");
        sb.append("    addSubscriptionPlans: ").append(this.toIndentedString(this.addSubscriptionPlans)).append("\n");
        sb.append("    removeSubscriptionPlans: ").append(this.toIndentedString(this.removeSubscriptionPlans)).append("\n");
        sb.append("    updateSubscriptionPlans: ").append(this.toIndentedString(this.updateSubscriptionPlans)).append("\n");
        sb.append("    renew: ").append(this.toIndentedString(this.renew)).append("\n");
        sb.append("    renewals: ").append(this.toIndentedString(this.renewals)).append("\n");
        sb.append("    cancel: ").append(this.toIndentedString(this.cancel)).append("\n");
        sb.append("    pause: ").append(this.toIndentedString(this.pause)).append("\n");
        sb.append("    resume: ").append(this.toIndentedString(this.resume)).append("\n");
        sb.append("    replaceSubscriptionPlans: ").append(this.toIndentedString(this.replaceSubscriptionPlans)).append("\n");
        sb.append("    terms: ").append(this.toIndentedString(this.terms)).append("\n");
        sb.append("    billToId: ").append(this.toIndentedString(this.billToId)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    billingDocumentSettings: ").append(this.toIndentedString(this.billingDocumentSettings)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    changeReason: ").append(this.toIndentedString(this.changeReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

