/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class PaymentMethodVerificationRequest {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_SECURITY_CODE = "security_code";
    @SerializedName(value="security_code")
    private String securityCode;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY = "payment_gateway";
    @SerializedName(value="payment_gateway")
    private String paymentGateway;
    public static final String SERIALIZED_NAME_GATEWAY_OPTIONS = "gateway_options";
    @SerializedName(value="gateway_options")
    private Map<String, Object> gatewayOptions = null;

    public PaymentMethodVerificationRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Three-letter ISO currency code.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentMethodVerificationRequest securityCode(String securityCode) {
        this.securityCode = securityCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Card security code.")
    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public PaymentMethodVerificationRequest paymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093d07ae636bb017ae97518762aa3", value="The name of the payment gateway instance. If no value is specified for this field, the default payment gateway of your Zuora tenant will be used.")
    public String getPaymentGateway() {
        return this.paymentGateway;
    }

    public void setPaymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
    }

    public PaymentMethodVerificationRequest gatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
        return this;
    }

    public PaymentMethodVerificationRequest putGatewayOptionsItem(String key, Object gatewayOptionsItem) {
        if (this.gatewayOptions == null) {
            this.gatewayOptions = new HashMap<String, Object>();
        }
        this.gatewayOptions.put(key, gatewayOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="A hash containing gateway-specific parameters.")
    public Map<String, Object> getGatewayOptions() {
        return this.gatewayOptions;
    }

    public void setGatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodVerificationRequest paymentMethodVerificationRequest = (PaymentMethodVerificationRequest)o;
        return Objects.equals(this.currency, paymentMethodVerificationRequest.currency) && Objects.equals(this.securityCode, paymentMethodVerificationRequest.securityCode) && Objects.equals(this.paymentGateway, paymentMethodVerificationRequest.paymentGateway) && Objects.equals(this.gatewayOptions, paymentMethodVerificationRequest.gatewayOptions);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.securityCode, this.paymentGateway, this.gatewayOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodVerificationRequest {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    securityCode: ").append(this.toIndentedString(this.securityCode)).append("\n");
        sb.append("    paymentGateway: ").append(this.toIndentedString(this.paymentGateway)).append("\n");
        sb.append("    gatewayOptions: ").append(this.toIndentedString(this.gatewayOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

