/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.ResumeSubscriptionRequest;

public class PauseSubscriptionRequest {
    public static final String SERIALIZED_NAME_PAUSE_DATE = "pause_date";
    @SerializedName(value="pause_date")
    private String pauseDate;
    public static final String SERIALIZED_NAME_PAUSE_AT = "pause_at";
    @SerializedName(value="pause_at")
    private PauseAtEnum pauseAt;
    public static final String SERIALIZED_NAME_PAUSE_INTERVAL_COUNT = "pause_interval_count";
    @SerializedName(value="pause_interval_count")
    private BigDecimal pauseIntervalCount;
    public static final String SERIALIZED_NAME_PAUSE_INTERVAL = "pause_interval";
    @SerializedName(value="pause_interval")
    private PauseIntervalEnum pauseInterval;
    public static final String SERIALIZED_NAME_CHANGE_REASON = "change_reason";
    @SerializedName(value="change_reason")
    private String changeReason;
    public static final String SERIALIZED_NAME_RESUME_BEHAVIOR = "resume_behavior";
    @SerializedName(value="resume_behavior")
    private ResumeSubscriptionRequest resumeBehavior;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;

    public PauseSubscriptionRequest pauseDate(String pauseDate) {
        this.pauseDate = pauseDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date on which the subscription is paused.")
    public String getPauseDate() {
        return this.pauseDate;
    }

    public void setPauseDate(String pauseDate) {
        this.pauseDate = pauseDate;
    }

    public PauseSubscriptionRequest pauseAt(PauseAtEnum pauseAt) {
        this.pauseAt = pauseAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can be either the end of the current billing period or a specific date.")
    public PauseAtEnum getPauseAt() {
        return this.pauseAt;
    }

    public void setPauseAt(PauseAtEnum pauseAt) {
        this.pauseAt = pauseAt;
    }

    public PauseSubscriptionRequest pauseIntervalCount(BigDecimal pauseIntervalCount) {
        this.pauseIntervalCount = pauseIntervalCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of intervals in a duration where the subscription is paused. For example, pause_interval=year and pause_interval_count=1 represents a 1-year pause.")
    public BigDecimal getPauseIntervalCount() {
        return this.pauseIntervalCount;
    }

    public void setPauseIntervalCount(BigDecimal pauseIntervalCount) {
        this.pauseIntervalCount = pauseIntervalCount;
    }

    public PauseSubscriptionRequest pauseInterval(PauseIntervalEnum pauseInterval) {
        this.pauseInterval = pauseInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit in which the pause duration is defined. One of day, week, month or year.")
    public PauseIntervalEnum getPauseInterval() {
        return this.pauseInterval;
    }

    public void setPauseInterval(PauseIntervalEnum pauseInterval) {
        this.pauseInterval = pauseInterval;
    }

    public PauseSubscriptionRequest changeReason(String changeReason) {
        this.changeReason = changeReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief description of the reason for this change.")
    public String getChangeReason() {
        return this.changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public PauseSubscriptionRequest resumeBehavior(ResumeSubscriptionRequest resumeBehavior) {
        this.resumeBehavior = resumeBehavior;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ResumeSubscriptionRequest getResumeBehavior() {
        return this.resumeBehavior;
    }

    public void setResumeBehavior(ResumeSubscriptionRequest resumeBehavior) {
        this.resumeBehavior = resumeBehavior;
    }

    public PauseSubscriptionRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PauseSubscriptionRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PauseSubscriptionRequest pauseSubscriptionRequest = (PauseSubscriptionRequest)o;
        return Objects.equals(this.pauseDate, pauseSubscriptionRequest.pauseDate) && Objects.equals((Object)this.pauseAt, (Object)pauseSubscriptionRequest.pauseAt) && Objects.equals(this.pauseIntervalCount, pauseSubscriptionRequest.pauseIntervalCount) && Objects.equals((Object)this.pauseInterval, (Object)pauseSubscriptionRequest.pauseInterval) && Objects.equals(this.changeReason, pauseSubscriptionRequest.changeReason) && Objects.equals(this.resumeBehavior, pauseSubscriptionRequest.resumeBehavior) && Objects.equals(this.customFields, pauseSubscriptionRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pauseDate, this.pauseAt, this.pauseIntervalCount, this.pauseInterval, this.changeReason, this.resumeBehavior, this.customFields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PauseSubscriptionRequest {\n");
        sb.append("    pauseDate: ").append(this.toIndentedString(this.pauseDate)).append("\n");
        sb.append("    pauseAt: ").append(this.toIndentedString((Object)this.pauseAt)).append("\n");
        sb.append("    pauseIntervalCount: ").append(this.toIndentedString(this.pauseIntervalCount)).append("\n");
        sb.append("    pauseInterval: ").append(this.toIndentedString((Object)this.pauseInterval)).append("\n");
        sb.append("    changeReason: ").append(this.toIndentedString(this.changeReason)).append("\n");
        sb.append("    resumeBehavior: ").append(this.toIndentedString(this.resumeBehavior)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PauseIntervalEnum {
        MONTH("month"),
        DAY("day"),
        YEAR("year"),
        WEEK("week"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PauseIntervalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PauseIntervalEnum fromValue(String value) {
            for (PauseIntervalEnum b : PauseIntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PauseIntervalEnum> {
            public void write(JsonWriter jsonWriter, PauseIntervalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PauseIntervalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PauseIntervalEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PauseAtEnum {
        INVOICE_PERIOD_END("invoice_period_end"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PauseAtEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PauseAtEnum fromValue(String value) {
            for (PauseAtEnum b : PauseAtEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PauseAtEnum> {
            public void write(JsonWriter jsonWriter, PauseAtEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PauseAtEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PauseAtEnum.fromValue(value);
            }
        }
    }
}

