/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Account;
import org.openapitools.client.model.ArTransactionsOrders;
import org.openapitools.client.model.LineItemListResponse;
import org.openapitools.client.model.PostSubscriptionOrderResponse;
import org.openapitools.client.model.WriteOff;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class OrderCancelResponse {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ORDER_NUMBER = "order_number";
    @SerializedName(value="order_number")
    private String orderNumber;
    public static final String SERIALIZED_NAME_ORDER_DATE = "order_date";
    @SerializedName(value="order_date")
    private LocalDate orderDate;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private Account account;
    public static final String SERIALIZED_NAME_LINE_ITEMS = "line_items";
    @SerializedName(value="line_items")
    private List<LineItemListResponse> lineItems = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
    @SerializedName(value="subscriptions")
    private List<PostSubscriptionOrderResponse> subscriptions = null;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_SCHEDULED_DATE = "scheduled_date";
    @SerializedName(value="scheduled_date")
    private LocalDate scheduledDate;
    public static final String SERIALIZED_NAME_SCHEDULED_DATE_POLICY = "scheduled_date_policy";
    @SerializedName(value="scheduled_date_policy")
    private String scheduledDatePolicy;
    public static final String SERIALIZED_NAME_AR_TRANSACTIONS = "ar_transactions";
    @SerializedName(value="ar_transactions")
    private ArTransactionsOrders arTransactions;
    public static final String SERIALIZED_NAME_WRITE_OFFS = "write_offs";
    @SerializedName(value="write_offs")
    private List<WriteOff> writeOffs = null;

    public OrderCancelResponse() {
    }

    public OrderCancelResponse(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OrderCancelResponse customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public OrderCancelResponse putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public OrderCancelResponse orderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The order number of the new order. If not provided, system will auto-generate a number for this order.     Note: Ensure that the order number does not contain a slash.")
    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public OrderCancelResponse orderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date when the order is signed. All the order actions under this order will use this order date as the contract effective date if the contract effective date field is skipped or its value is left as null.")
    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public OrderCancelResponse description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of test account", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OrderCancelResponse category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Category of the order to indicate a product sale or return. Default value is `sale`.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public OrderCancelResponse accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account associated with this subscription.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OrderCancelResponse account(Account account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information of the new account associated with the subscription.")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public OrderCancelResponse lineItems(List<LineItemListResponse> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public OrderCancelResponse addLineItemsItem(LineItemListResponse lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItemListResponse>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Order line items are non-subscription-based items created by an order, representing transactional charges such as one-time fees, physical goods, or professional service charges that are not sold as subscription services.    By specifying this field, you can launch non-subscription and unified monetization business models in Zuora, in addition to subscription business models.")
    public List<LineItemListResponse> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItemListResponse> lineItems) {
        this.lineItems = lineItems;
    }

    public OrderCancelResponse subscriptions(List<PostSubscriptionOrderResponse> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public OrderCancelResponse addSubscriptionsItem(PostSubscriptionOrderResponse subscriptionsItem) {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<PostSubscriptionOrderResponse>();
        }
        this.subscriptions.add(subscriptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Each item includes specific fields based on the intended order action.")
    public List<PostSubscriptionOrderResponse> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<PostSubscriptionOrderResponse> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public OrderCancelResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the order.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public OrderCancelResponse scheduledDate(LocalDate scheduledDate) {
        this.scheduledDate = scheduledDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when the order is scheduled to be processed.")
    public LocalDate getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(LocalDate scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public OrderCancelResponse scheduledDatePolicy(String scheduledDatePolicy) {
        this.scheduledDatePolicy = scheduledDatePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date policy of the scheduled order.")
    public String getScheduledDatePolicy() {
        return this.scheduledDatePolicy;
    }

    public void setScheduledDatePolicy(String scheduledDatePolicy) {
        this.scheduledDatePolicy = scheduledDatePolicy;
    }

    public OrderCancelResponse arTransactions(ArTransactionsOrders arTransactions) {
        this.arTransactions = arTransactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArTransactionsOrders getArTransactions() {
        return this.arTransactions;
    }

    public void setArTransactions(ArTransactionsOrders arTransactions) {
        this.arTransactions = arTransactions;
    }

    public OrderCancelResponse writeOffs(List<WriteOff> writeOffs) {
        this.writeOffs = writeOffs;
        return this;
    }

    public OrderCancelResponse addWriteOffsItem(WriteOff writeOffsItem) {
        if (this.writeOffs == null) {
            this.writeOffs = new ArrayList<WriteOff>();
        }
        this.writeOffs.add(writeOffsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing documents that are written off.")
    public List<WriteOff> getWriteOffs() {
        return this.writeOffs;
    }

    public void setWriteOffs(List<WriteOff> writeOffs) {
        this.writeOffs = writeOffs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderCancelResponse orderCancelResponse = (OrderCancelResponse)o;
        return Objects.equals(this.id, orderCancelResponse.id) && Objects.equals(this.updatedById, orderCancelResponse.updatedById) && Objects.equals(this.updatedTime, orderCancelResponse.updatedTime) && Objects.equals(this.createdById, orderCancelResponse.createdById) && Objects.equals(this.createdTime, orderCancelResponse.createdTime) && Objects.equals(this.customFields, orderCancelResponse.customFields) && Objects.equals(this.customObjects, orderCancelResponse.customObjects) && Objects.equals(this.orderNumber, orderCancelResponse.orderNumber) && Objects.equals(this.orderDate, orderCancelResponse.orderDate) && Objects.equals(this.description, orderCancelResponse.description) && Objects.equals((Object)this.category, (Object)orderCancelResponse.category) && Objects.equals(this.accountId, orderCancelResponse.accountId) && Objects.equals(this.account, orderCancelResponse.account) && Objects.equals(this.lineItems, orderCancelResponse.lineItems) && Objects.equals(this.subscriptions, orderCancelResponse.subscriptions) && Objects.equals((Object)this.state, (Object)orderCancelResponse.state) && Objects.equals(this.scheduledDate, orderCancelResponse.scheduledDate) && Objects.equals(this.scheduledDatePolicy, orderCancelResponse.scheduledDatePolicy) && Objects.equals(this.arTransactions, orderCancelResponse.arTransactions) && Objects.equals(this.writeOffs, orderCancelResponse.writeOffs);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.orderNumber, this.orderDate, this.description, this.category, this.accountId, this.account, this.lineItems, this.subscriptions, this.state, this.scheduledDate, this.scheduledDatePolicy, this.arTransactions, this.writeOffs});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderCancelResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    orderNumber: ").append(this.toIndentedString(this.orderNumber)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    scheduledDate: ").append(this.toIndentedString(this.scheduledDate)).append("\n");
        sb.append("    scheduledDatePolicy: ").append(this.toIndentedString(this.scheduledDatePolicy)).append("\n");
        sb.append("    arTransactions: ").append(this.toIndentedString(this.arTransactions)).append("\n");
        sb.append("    writeOffs: ").append(this.toIndentedString(this.writeOffs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        COMPLETE("complete"),
        DRAFT("draft"),
        CANCELED("canceled"),
        SCHEDULED("scheduled"),
        EXECUTING("executing"),
        FAILED("failed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        SALE("sale"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

